let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
let tipo_viaje = 2;
let momento_actual = moment().format('YYYY-MM-DDTHH:mm');
$(document).ready(function() {
    let params = new URLSearchParams(location.search);
    if (params.get('t')) {
        tipo_viaje = 2;
    }
    $("#load_screen").toggle();
    cargar_chofer();
    $("#fechasalida").val(momento_actual);
    $("#fechallegada").val(momento_actual);

});
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});
// $("#id_sucursales").change(function() {
//     $table.bootstrapTable('removeAll');
//     cargar_tabla();
// });


function cargar_chofer() {
    let tipo_cliente = 2;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_cliente_chofer/' + tipo_cliente,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            cargar_vehiculo();
            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_chofer");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
            }
        },
        error: error


    });
}


function cargar_vehiculo() {
    let id_empresa = 2;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_vehiculos',
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            cargar_sucursales();

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_vehiculo");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
            }
        },
        error: error


    });
}

function cargar_sucursales() {
    let id_empresa = 1;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_sucursal/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#load_screen").hide();

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_sucursales");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
            }
            //cargar_tabla();
        },
        error: error


    });
}

function cargar_tabla() {
    $.ajax({
        url: urlServicio + 'API_REST/cargar_viaje/' + 1,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#load_screen").hide();

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.add_compra = '<a data-add="' + element.id + '" class="font-20 text-primary add"><i class="fa fa-plus"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                    sucursales.push(element);
                }

                data_table_cargar(sucursales);
            }
        },
        error: error


    });
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    agregar_tabla(t); 
});

$(document).on('click', '.add', function(e) {
    location.href = 'registro_compra.html?id_viaje=' + this.dataset.add;
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Esta seguro de eliminar viaje seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_viaje(t);
        }
    }); 
});
$(".delete").click(function() {

    //eliminar_sucursal(this.dataset.delete)
});

function agregar_tabla(id) {
    limpiar();
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    let fecha_salida = moment(datos.fecha_origen).format('YYYY-MM-DDTHH:mm');
    let fecha_llegada = moment(datos.fecha_destino).format('YYYY-MM-DDTHH:mm');
    $("#origen").val(datos.origen);
    $("#destino").val(datos.destino);
    $("#id_chofer").val(datos.id_chofer_t);
    $("#id_vehiculo").val(datos.id_vehiculo_t);
    $("#id_sucursales").val(datos.id_sucursal_t);
    $("#costo").val(datos.costo);
    // $("#descripcion").val(datos.descripcion);
    $("#fechasalida").val(fecha_salida);
    $("#fechallegada").val(fecha_llegada);
    $('html, body').animate({
        scrollTop: $("#origen").offset().top - 100
    }, 500);
}
$(".guardar").click(function() {
    if (id_sucursal > 0) {
        if (validar($("#origen")) && validar($("#destino"))) {

            actualizar_viaje();

        }
    } else {
        if (validar($("#origen")) && validar($("#destino"))) {

            insertar_viaje();
        }
    }
});
$(".cancelar").click(function() {
    if (tipo_viaje == 1) {
        location.href = 'lista_viajes_compras.html';
    } else {
        location.href = 'lista_viajes_ventas.html';
    }
});

function insertar_viaje() {
    let aray = [];
    let datos = {};

    datos.origen = $("#origen").val();
    datos.destino = $("#destino").val();
    datos.id_chofer_t = $("#id_chofer").val();
    datos.id_vehiculo_t = $("#id_vehiculo").val();
    datos.id_sucursal_t = $("#id_sucursales").val();
    datos.chofer = $("#id_chofer option:selected").text();
    datos.vehiculo = $("#id_vehiculo option:selected").text();
    datos.sucursal = $("#id_sucursales option:selected").text();
    datos.costo = $("#costo").val();
    datos.id_tipo_viaje = tipo_viaje;
    datos.fecha_origen = $("#fechasalida").val();
    datos.fecha_destino = $("#fechallegada").val();
    datos.estado = 1;
    datos.id_usuario = usuario.id;

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_viaje',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                id_sucursal = d.msg;
                datos.id = d.msg;
                datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.add_compra = '<a data-add="' + d.msg + '" class="font-20 text-primary add"><i class="fa fa-plus"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);
                todo_disabled();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });
}

function actualizar_viaje() {
    var datos = {};
    let fecha_salida = moment($("#fechasalida").val()).format('YYYY-MM-DD H:mm');
    let fecha_llegada = moment($("#fechallegada").val()).format('YYYY-MM-DD H:mm');
    datos.id = id_sucursal;
    datos.origen = $("#origen").val();
    datos.destino = $("#destino").val();
    datos.id_chofer = $("#id_chofer").val();
    datos.id_vehiculo = $("#id_vehiculo").val();
    datos.id_sucursal = $("#id_sucursales").val();

    datos.costo = $("#costo").val();
    datos.fecha_origen = $("#fechasalida").val();
    datos.fecha_destino = $("#fechallegada").val();
    datos.estado = 1;
    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_viaje',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_sucursal,
                    row: {

                        origen: $("#origen").val(),
                        destino: $("#destino").val(),
                        id_chofer_t: $("#id_chofer").val(),
                        id_vehiculo_t: $("#id_vehiculo").val(),
                        id_sucursal_t: $("#id_sucursales").val(),
                        chofer: $("#id_chofer option:selected").text(),
                        vehiculo: $("#id_vehiculo option:selected").text(),
                        sucursal: $("#id_sucursales option:selected").text(),
                        costo: $("#costo").val(),
                        fecha_origen: fecha_salida,
                        fecha_destino: fecha_llegada,

                    }
                });
                limpiar();
            } else {
                limpiar();
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function eliminar_viaje(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_viaje',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function limpiar() {
    $("#origen").removeAttr('disabled');
    $("#destino").removeAttr('disabled');
    $("#id_chofer").removeAttr('disabled');
    $("#id_vehiculo").removeAttr('disabled');
    $("#id_sucursales").removeAttr('disabled');
    $("#costo").removeAttr('disabled');
    $("#fechasalida").removeAttr('disabled');
    $("#fechallegada").removeAttr('disabled');
}

function todo_disabled() {
    //id_sucursal = 0;
    $("#origen").attr('disabled', true);
    $("#destino").attr('disabled', true);
    $("#id_chofer").attr('disabled', true);
    $("#id_vehiculo").attr('disabled', true);
    $("#id_sucursales").attr('disabled', true);
    $("#costo").attr('disabled', true);
    $("#fechasalida").attr('disabled', true);
    $("#fechallegada").attr('disabled', true);

}

function error(data, textStatus, jqXHR) {
    $('.loader').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}