let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
// $(document).ready(function() {
//     cargar_tabla();
// });
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});




function cargar_tabla() {
    let id_empresa = usuario.id_empresa;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_usuarios/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                    sucursales.push(element);
                }
                cargar_roles(d.roles);

                data_table_cargar(sucursales);
            }
        },
        error: error


    });
}

function cargar_roles(array) {
    let rol = $("#id_rol").html("");
    for (let index = 0; index < array.length; index++) {
        const element = array[index];
        rol.append('<option value="' + element.id + '">' + element.nombre + '</option>');
    }
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    cargar_datos_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar usuario seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_usuario(t);
        }
    }); 
});


function cargar_datos_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#nombre").val(datos.nombre);
    $("#telefono").val(datos.telefono);
    $("#correo").val(datos.correo);
    $("#cargo").val(datos.cargo);
    $("#salario").val(datos.salario);
    $("#id_rol").val(datos.id_rol);



    $('html, body').animate({
        scrollTop: $("#nombre").offset().top - 100
    }, 500);
}
$(".guardar").click(function() {
    if (validar($("#nombre")) && validar($("#telefono")) && validar($("#correo")) && validar($("#pass"))) {
        $(".caja_loader").show();

        var datos = {};

        datos.nombre = $("#nombre").val();
        datos.correo = $("#correo").val();
        datos.pass = $("#pass").val();
        datos.telefono = $("#telefono").val();
        datos.id_rol = $("#id_rol").val();
        datos.cargo = $("#cargo").val();
        datos.salario = $("#salario").val();
        datos.id_empresa = usuario.id_empresa;
        datos.id = id_sucursal;

        if (id_sucursal > 0) {

            actualizar_usuario(datos);
        } else {
            insertar_usuario(datos);

        }

    }

});
$(".cancelar").click(function() {
    limpiar();
});

function insertar_usuario(datos) {
    let aray = [];
    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_usuario',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();

            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.rol = $("#id_rol option:selected").text();
                datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);
                limpiar();
            } else {

                Snackbar.show({ text: d.errorMessage, pos: 'top-center' });


            }

        },
        error: error



    });
}

function actualizar_usuario(datos) {

    var enviar = JSON.stringify(datos);


    $.ajax({
        url: urlServicio + 'API_REST/actualizar_usuario',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();

            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_sucursal,
                    row: {
                        nombre: $("#nombre").val(),
                        telefono: $("#telefono").val(),
                        id_rol: $("#id_rol").val(),
                        rol: $("#id_rol option:selected").text(),
                        cargo: $("#cargo").val(),
                        salario: $("#salario").val(),

                    }
                });
                limpiar();
            } else {
                limpiar();
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: error



    });


}

function eliminar_usuario(id_) {
    $(".caja_loader").show();

    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_usuario',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();

            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: error



    });


}

function limpiar() {
    id_sucursal = 0;
    $("#nombre").val('');
    $("#correo").val('');
    $("#telefono").val('');
    $("#cargo").val('');
    $("#salario").val('');

}