let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
let id_empresa = 0;

$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});

function cargar_tabla() {
    id_empresa = usuario.id_empresa;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_tipo_ingreso_egreso/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;

                res.map((element) => {
                    element.id_tipo_categorian = 'Egreso'
                    if (element.id_tipo_categoria == 1) {
                        element.id_tipo_categorian = 'Ingreso'
                    }
                    element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                    sucursales.push(element);
                });

                data_table_cargar(sucursales);
            }
        },
        error: error


    });
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    agregar_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_sucursal(t);
        }
    }); 
});
$(".delete").click(function() {

    //eliminar_sucursal(this.dataset.delete)
});

function agregar_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#nombre").val(datos.nombre);
    $("#id_tipo_categoria").val(datos.id_tipo_categoria);
    $("#descripcion").val(datos.descripcion);

    $('html, body').animate({
        scrollTop: $("#nombre").offset().top - 100
    }, 500);
}
$(".guardar").click(function() {
    if (id_sucursal > 0) {
        if (validar($("#nombre")) && validar($("#descripcion"))) {

            actualizar_sucursal();

        }
    } else {
        if (validar($("#nombre")) && validar($("#descripcion"))) {

            insertar_sucursal();
        }
    }
});
$(".cancelar").click(function() {
    limpiar();
});

function insertar_sucursal() {

    let aray = [];
    let datos = {};
    datos.id_tipo_categoria = $("#id_tipo_categoria").val();
    datos.id_empresa = id_empresa;
    datos.nombre = $("#nombre").val();
    datos.descripcion = $("#descripcion").val();

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_tipo_ingreso_egreso',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.id_tipo_categoria = $("#id_tipo_categoria").val();
                datos.id_tipo_categorian = $("#id_tipo_categoria option:selected").text();
                datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: error



    });
}

function actualizar_sucursal() {
    var datos = {};
    datos.id = id_sucursal;
    datos.id_tipo_categoria = $("#id_tipo_categoria").val();
    datos.nombre = $("#nombre").val();
    datos.descripcion = $("#descripcion").val();
    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_tipo_ingreso_egreso',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_sucursal,
                    row: {

                        nombre: $("#nombre").val(),
                        id_tipo_categoria: $("#id_tipo_categoria").val(),
                        id_tipo_categorian: $("#id_tipo_categoria option:selected").text(),
                        descripcion: $("#descripcion").val()

                    }
                });
                limpiar();
            } else {
                limpiar();
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: error



    });


}

function eliminar_sucursal(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_tipo_ingreso_egreso',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: error



    });


}

function limpiar() {
    id_sucursal = 0;
    $("#nombre").val('');
    $("#id_tipo_categoria").val('');
    $("#descripcion").val('');



}

function error(data, textStatus, jqXHR) {
    $('.loader').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}