let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
$(document).ready(function() {
    cargar_sucursales();
});
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});

function cargar_sucursales() {
    let id_empresa = 1;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_colonias',
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_colonia");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
                cargar_tabla();
            }
        },
        error: error


    });
}



function cargar_tabla() {
    let id_empresa = 1;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_responsable',
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                    sucursales.push(element);
                }

                data_table_cargar(sucursales);
            }
        },
        error: error


    });
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    agregar_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_sucursal(t);
        }
    }); 
});
$(".delete").click(function() {

    //eliminar_sucursal(this.dataset.delete)
});

function agregar_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#nombre").val(datos.nombre);
    $("#nit").val(datos.nit);
    $("#direccion").val(datos.direccion);
    $("#telefono").val(datos.telefono);
    $("#correo").val(datos.correo);
    $("#id_colonia").val(datos.id_colonia);

    $('html, body').animate({
        scrollTop: $("#nombre").offset().top - 100
    }, 500);
}
$(".guardar").click(function() {
    if (id_sucursal > 0) {
        if (validar($("#nombre")) && validar($("#nit")) && validar($("#direccion")) && validar($("#telefono")) && validar($("#correo"))) {

            actualizar_sucursal();

        }
    } else {
        if (validar($("#nombre")) && validar($("#nit")) && validar($("#direccion")) && validar($("#telefono")) && validar($("#correo"))) {

            insertar_sucursal();
        }
    }
});
$(".cancelar").click(function() {
    limpiar();
});

function insertar_sucursal() {
    let aray = [];
    let datos = {};
    datos.id_colonia = $("#id_colonia").val();
    datos.nombre = $("#nombre").val();
    datos.nit = $("#nit").val();
    datos.direccion = $("#direccion").val();
    datos.telefono = $("#telefono").val();
    datos.correo = $("#correo").val();

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_responsable',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.id_colonia = $("#id_colonia").val();
                datos.colonia = $("#id_colonia option:selected").text();
                datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });
}

function actualizar_sucursal() {
    var datos = {};
    datos.id = id_sucursal;
    datos.id_colonia = $("#id_colonia").val();
    datos.nombre = $("#nombre").val();
    datos.nit = $("#nit").val();
    datos.direccion = $("#direccion").val();
    datos.telefono = $("#telefono").val();
    datos.correo = $("#correo").val();

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_responsable',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_sucursal,
                    row: {
                        id_colonia: datos.id_colonia,
                        nombre: $("#nombre").val(),
                        nombre_factura: $("#nombre_factura").val(),
                        direccion: $("#direccion").val(),
                        colonia: $("#id_colonia option:selected").text(),

                    }
                });
                limpiar();
            } else {
                limpiar();
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function eliminar_sucursal(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_responsable',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function limpiar() {
    id_sucursal = 0;
    $("#nombre").val('');
    $("#nit").val('');
    $("#direccion").val('');
    $("#telefono").val('');
    $("#correo").val('');


}

function error(data, textStatus, jqXHR) {
    $('.loader').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}