var $table = $('#table');
let momento_actual = moment().format('YYYY-MM-DD');
let compras = [];
$(document).ready(function() {
    //$("#load_screen").toggle();
    $("#fecha_ini").val(momento_actual);
    $("#fecha_fin").val(momento_actual);
    $("#load_screen").show();

    cargar_sucursal();
});
$(document).on('click', '.enviar', function() {
    $("#load_screen").toggle();

    compras = [];
    data_table_cargar(compras);
    carga_tabla();
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar compra seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_compra(t);
        }
    });
});
$(document).on('click', '.print', function(e) {
    let t = this.dataset.print;
    window.open('imprimir_venta.html?v=' + t, '_blank');

});

function cargar_sucursal() {

    $.ajax({
        url: urlServicio + 'API_REST/cargar_sucursal/' + 1,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            cargar_cliente();
            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    $("#id_sucursal").append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }

            }
        },
        error: error


    });
}

function cargar_cliente() {
    $.ajax({
        url: urlServicio + 'API_REST/cargar_cliente_chofer/' + 1,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            cargar_responsable();
            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    $("#id_cliente").append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }

            }
        },
        error: error


    });
}

function cargar_responsable() {
    $.ajax({
        url: urlServicio + 'API_REST/cargar_responsable',
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#load_screen").hide();
            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    $("#id_responsable").append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }

            }
        },
        error: error


    });
}

function carga_tabla() {
    let fecha_ini = $("#fecha_ini").val();
    let fecha_fin = $("#fecha_fin").val();
    let id_sucursal = $("#id_sucursal").val();
    let id_cliente = $("#id_cliente").val();
    let id_responsable = $("#id_responsable").val();
    let merma = 0;
    let viaje = 1;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_ventas_reporte/' + fecha_ini + '/' + fecha_fin + '/' + id_sucursal + '/' + id_cliente + '/' + id_responsable + '/' + merma + '/' + viaje,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#load_screen").hide();
            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    if (element.id_viaje > 0) {
                        element.id_viaje = 'Con viaje';
                        element.ver = '<a data-print="' + element.id + '" class="font-20 text-danger print"><i class="fa fa-eye"></i></a>';
                        compras.push(element);

                    }

                    // element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    // element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                }

                data_table_cargar(compras);
            }
        },
        error: error


    });
}

function eliminar_compra(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_compra',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                //limpiar();
            }

        },
        error: error



    });
}

function error(data, textStatus, jqXHR) {
    $('#load_screen').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}