var $table = $('#table');
let momento_actual = moment().format('YYYY-MM-DD');
let compras = [];
$(document).ready(function() {
    //$("#load_screen").toggle();
    $("#fecha_ini").val(momento_actual);
    $("#fecha_fin").val(momento_actual);
    $("#load_screen").show();

    cargar_sucursal();
});
$(document).on('click', '.enviar', function() {
    $("#load_screen").toggle();

    compras = [];
    data_table_cargar(compras);
    carga_tabla();
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar compra seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_compra(t);
        }
    });
});

function cargar_sucursal() {

    $.ajax({
        url: urlServicio + 'API_REST/cargar_sucursal/' + 1,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            cargar_cliente();
            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    $("#id_sucursal").append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }

            }
        },
        error: error


    });
}

function cargar_cliente() {
    $.ajax({
        url: urlServicio + 'API_REST/cargar_cliente_chofer/' + 2,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            cargar_responsable();
            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    $("#id_cliente").append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }

            }
        },
        error: error


    });
}

function cargar_responsable() {
    $.ajax({
        url: urlServicio + 'API_REST/cargar_productos',
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#load_screen").hide();
            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    $("#id_producto").append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }

            }
        },
        error: error


    });
}

function carga_tabla() {
    let fecha_ini = $("#fecha_ini").val();
    let fecha_fin = $("#fecha_fin").val();
    let producto = $("#id_producto").val();
    $.ajax({
        url: urlServicio + 'API_REST/reporte_merma/' + fecha_ini + '/' + fecha_fin + '/' + producto,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#load_screen").hide();
            if (d.errorCode == 0) {
                let res = d.msg;


                data_table_cargar(res);
            }
        },
        error: error


    });
}

function eliminar_compra(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_compra',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                //limpiar();
            }

        },
        error: error



    });
}

function error(data, textStatus, jqXHR) {
    $('#load_screen').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}