var $table = $("#table");
let momento_actual = moment().format("YYYY-MM-DD");
let compras = [];
let almacenes = [];
let id_empresa = 0;

$(".enviar").click(function (e) {
  e.preventDefault();
  $(".caja_loader").show();
  data_table_cargar([]);
  cargar_inventario();
});

$("#id_sucursal").change(function () {
  llenar_almacen(almacenes);
});

function cargar_inventario() {
  let id_almacen = $("#id_almacen").val();
  $.ajax({
    url:
      urlServicio +
      "API_REST/reporte_inventario/" +
      id_almacen +
      "/" +
      id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".caja_loader").hide();
      if (d.errorCode == 0) {
        let res = d.msg;
        let datos_modal = obtenerDatosModal(res);
        // agregamos los datos a la tabla del modal
        agregarDatosModal(datos_modal);
        $("#myModal").modal("show");
        data_table_cargar(res);
      }
    },
    error: error,
  });
}

function cargar_tabla() {
  id_empresa = usuario.id_empresa;
  $.ajax({
    url: urlServicio + "API_REST/cargar_sucursal/" + id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".caja_loader").hide();

      if (d.errorCode == 0) {
        let res = d.msg;
        for (let index = 0; index < res.length; index++) {
          const element = res[index];
          $("#id_sucursal").append(
            '<option value="' + element.id + '">' + element.nombre + "</option>"
          );
        }
        cargar_almacen();
      }
    },
    error: error,
  });
}

function cargar_almacen() {
  $.ajax({
    url: urlServicio + "API_REST/cargar_almacen_todos/" + id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      if (d.errorCode == 0) {
        let res = d.msg;
        almacenes = res;
        for (let index = 0; index < res.length; index++) {
          const element = res[index];
          $("#id_almacen").append(
            '<option value="' + element.id + '">' + element.nombre + "</option>"
          );
        }
      }
    },
    error: error,
  });
}

function llenar_almacen(array) {
  let id_sucursal = $("#id_sucursal").val();
  if (id_sucursal != 0) {
    $("#id_almacen").html("<option value='0'>Todos</option>");
    for (let index = 0; index < array.length; index++) {
      const element = array[index];
      if (element.id_sucursal == id_sucursal) {
        $("#id_almacen").append(
          '<option value="' + element.id + '">' + element.nombre + "</option>"
        );
      }
    }
  } else {
    $("#id_almacen").html("<option value='0'>Todos</option>");
    for (let index = 0; index < array.length; index++) {
      const element = array[index];

      $("#id_almacen").append(
        '<option value="' + element.id + '">' + element.nombre + "</option>"
      );
    }
  }
}
function data_table_cargar(res) {
  var today = new Date();
  var now = today.toLocaleDateString("en-US");
  console.log(res);
  let data = [];

  $.each(res, function (i, item) {
    let row = {};

    row.id = item.id;
    row.codigo = item.codigo;
    row.lote = item.lote;
    row.nombre = item.nombre;
    row.cantidad = item.cantidad;
    row.almacen = item.almacen;
    row.sucursal = item.sucursal;
    row.fecha_vencimiento = item.fecha_vencimiento;
    row.dias_restantes = item.dias_restantes;

    /*  console.log(item.fecha_vencimiento,now); */
    if (item.dias_restantes<1) {
      row.codigo = '<span class="text-danger">' + item.codigo + "</span>";
      row.lote = '<span class="text-danger">' + item.lote + "</span>";
      row.nombre = '<span class="text-danger">' + item.nombre + "</span>";

      row.almacen = '<span class="text-danger">' + item.almacen + "</span>";
      row.sucursal = '<span class="text-danger">' + item.sucursal + "</span>";
      row.fecha_vencimiento =
        '<span class="text-danger">' + item.fecha_vencimiento + "</span>";
      row.dias_restantes =
        '<span class="text-danger">' + item.dias_restantes + "</span>";
    }

    data.push(row);
  });

  $("#table").bootstrapTable("load", data);
}

// función para obtener los datos que deseamos mostrar en el modal
function obtenerDatosModal(datos) {
  let datos_modal = [];
  for (let i = 0; i < datos.length; i++) {
    if (datos[i].dias_restantes < 1) {
      datos_modal.push({
        codigo: datos[i].codigo,
        lote: datos[i].lote,
        nombre: datos[i].nombre,
        stock: datos[i].cantidad,
        almacen: datos[i].almacen,
        sucursal: datos[i].sucursal,
        fecha_vencimiento: datos[i].fecha_vencimiento,
        dias_restantes: datos[i].dias_restantes,
      });
    }
  }
  return datos_modal;
}

// función para agregar los datos a la tabla del modal
function agregarDatosModal(datos_modal) {
  let tabla_modal = $("#myModal").find("table");
  tabla_modal.find("tbody").empty();
  for (let i = 0; i < datos_modal.length; i++) {
    let fila = $("<tr>");
    fila.append($("<td>").text(datos_modal[i].codigo));
    fila.append($("<td>").text(datos_modal[i].lote));
    fila.append($("<td>").text(datos_modal[i].nombre));
    fila.append($("<td>").text(datos_modal[i].stock));
    fila.append($("<td>").text(datos_modal[i].almacen));
    fila.append($("<td>").text(datos_modal[i].sucursal));
    fila.append($("<td>").text(datos_modal[i].fecha_vencimiento));
    fila.append($("<td>").text(datos_modal[i].dias_restantes));
    tabla_modal.find("tbody").append(fila);
  }
}