var $table = $("#table");
let momento_actual = moment().format("YYYY-MM-DD");
let compras = [];
let almacenes = [];
let id_empresa = 0;
$("#fecha_ini").val(momento_actual);
$("#fecha_fin").val(momento_actual);

// $(document).ready(function() {
//     //$("#load_screen").toggle();
//     $("#fecha_ini").val(momento_actual);
//     $("#fecha_fin").val(momento_actual);
//     cargar_sucursal();

// });
$(document).on("click", ".enviar", function () {
  $("#load_screen").toggle();
  compras = [];
  data_table_cargar(compras);
  cargar_ingresos();
});

$(document).on("click", ".imprimir", function (e) {
  let t = this.dataset.imprimir;
  window.open("imprimir_compra.html?v=" + t, "_blank");
});
$("#id_sucursal").change(function () {
  llenar_almacen(almacenes);
});

function cargar_ingresos() {
  let fecha_ini = $("#fecha_ini").val();
  let fecha_fin = $("#fecha_fin").val();
  let id_sucursal = $("#id_sucursal").val();
  let id_proveedor = $("#id_proveedor").val();
  $.ajax({
    url:
      urlServicio +
      "API_REST/reporte_compras/" +
      fecha_ini +
      "/" +
      fecha_fin +
      "/" +
      id_sucursal +
      "/" +
      id_proveedor +
      "/" +
      id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      $("#load_screen").hide();
      if (d.errorCode == 0) {
        let res = d.msg;
        for (let index = 0; index < res.length; index++) {
          const element = res[index];
          element.ver =
            '<a data-imprimir="' +
            element.id +
            '" class="font-20 text-primary imprimir"><i class="fa fa-print"></i></a>';
          compras.push(element);
        }

        data_table_cargar(compras);
      }
    },
    error: error,
  });
}

function cargar_tabla() {
  id_empresa = usuario.id_empresa;

  $.ajax({
    url: urlServicio + "API_REST/cargar_sucursal/" + id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      cargar_proveedor();
      if (d.errorCode == 0) {
        let res = d.msg;
        for (let index = 0; index < res.length; index++) {
          const element = res[index];
          $("#id_sucursal").append(
            '<option value="' + element.id + '">' + element.nombre + "</option>"
          );
        }
      }
    },
    error: error,
  });
}

function cargar_proveedor() {
  $.ajax({
    url: urlServicio + "API_REST/cargar_proveedor/" + id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      cargar_almacen();
      if (d.errorCode == 0) {
        let res = d.msg;
        for (let index = 0; index < res.length; index++) {
          const element = res[index];
          $("#id_proveedor").append(
            '<option value="' + element.id + '">' + element.nombre + "</option>"
          );
        }
      }
    },
    error: error,
  });
}

function cargar_almacen() {
  $.ajax({
    url: urlServicio + "API_REST/cargar_almacen_todos",
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      if (d.errorCode == 0) {
        let res = d.msg;
        almacenes = res;
        for (let index = 0; index < res.length; index++) {
          const element = res[index];
          $("#id_almacen").append(
            '<option value="' + element.id + '">' + element.nombre + "</option>"
          );
        }
      }
    },
    error: error,
  });
}

function llenar_almacen(array) {
  let id_sucursal = $("#id_sucursal").val();
  if (id_sucursal != 0) {
    $("#id_almacen").html("<option value='0'>Todos</option>");
    for (let index = 0; index < array.length; index++) {
      const element = array[index];
      if (element.id_sucursal == id_sucursal) {
        $("#id_almacen").append(
          '<option value="' + element.id + '">' + element.nombre + "</option>"
        );
      }
    }
  } else {
    $("#id_almacen").html("<option value='0'>Todos</option>");
    for (let index = 0; index < array.length; index++) {
      const element = array[index];

      $("#id_almacen").append(
        '<option value="' + element.id + '">' + element.nombre + "</option>"
      );
    }
  }
}

function error(data, textStatus, jqXHR) {
  $("#load_screen").hide();
  console.log(data);
  console.log(textStatus);
  console.log(jqXHR);
}
