let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
let productos = [];
let detalle_productos = [];
let contador = 0;
let id_viaje_u = 0;
$(document).ready(function() {
    let params = new URLSearchParams(location.search);
    id_viaje_u = params.get('id_viaje');

    $("#fecha_venta").val(moment().format('YYYY-MM-DD'));
    $(".fecha_modal").text(moment().format('YYYY-MM-DD'));
    cargar_campo(true);

    if (id_viaje_u > 0) {
        $(".campo_cliente").addClass("d-none");
        cargar_tabla();
    } else {
        $(".campo_responsable").addClass('d-none');

    }
});
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});
$("#fecha_venta").change(function() {
    $(".fecha_modal").text(this.value);
});
$("#id_sucursales").change(function() {
    $("#load_screen").show();
    id_sucursal = this.value;
    cargar_almacen();
});
$("#id_campo").change(function() {
    $("#load_screen").show();

    cargar_responsable_colonia(false);
});

function cargar_tabla() {
    $(".viajes").removeClass("d-none");
    $.ajax({
        url: urlServicio + 'API_REST/cargar_viaje_u/' + id_viaje_u,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                $("#origen").val(res.origen);
                $("#destino").val(res.destino);
                $("#chofer").val(res.chofer);
                $("#vehiculo").val(res.vehiculo);



            }
        },
        error: error


    });
}

function cargar_campo(primera_carga) {
    $("#load_screen").show();
    $.ajax({
        url: urlServicio + 'API_REST/cargar_campo',
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                let campo = $("#id_campo");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    campo.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
                cargar_responsable_colonia(primera_carga);

            }
        },
        error: error


    });
}

function cargar_responsable_colonia(primera_carga) {
    let id_campo = $("#id_campo").val();
    $.ajax({
        url: urlServicio + 'API_REST/cargar_responsable_colonia/' + id_campo,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            let campo = $("#id_responsable").html('');

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    campo.append('<option value="' + element.id + '">' + element.nombre + ', campo: ' + element.colonia + '</option>');
                }

            }
            if (primera_carga) {
                cargar_cliente_chofer();

            } else {
                $("#load_screen").hide();

            }
        },
        error: error


    });
}


function cargar_cliente_chofer() {

    $.ajax({
        url: urlServicio + 'API_REST/cargar_cliente_chofer/' + 1,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_cliente");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
                cargar_sucursales();

            }
        },
        error: error


    });
}

function cargar_sucursales() {

    let id_empresa = 1;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_sucursal/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            var sucursales = $("#id_sucursales").html('');

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
                cargar_almacen();

            }
        },
        error: error


    });
}

function cargar_almacen() {
    let id_sucursal = $("#id_sucursales").val();
    $("#id_almacenes").html('');
    $.ajax({
        url: urlServicio + 'API_REST/cargar_almacen/' + id_sucursal,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            let almacenes = $("#id_almacenes").html('');

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    almacenes.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
                cargar_productos();
            } else {
                productos = [];
                $("#productos_").html('');
            }
        },
        error: error


    });
}



function cargar_productos() {
    let id_almacen = $("#id_almacenes").val();
    $.ajax({
        url: urlServicio + 'API_REST/cargar_productos_venta/' + id_almacen,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#load_screen").hide();

            if (d.errorCode == 0) {
                let res = d.msg;
                productos = res;
                $("#productos_").html('');
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    pintar_productos(element);
                }
            } else {
                $("#productos_").html('<h4 class="text-center">No existe productos</h4>');
            }


        },
        error: error


    });
}

function pintar_productos(elemento) {
    let img = 'img/500.png';
    if (elemento.foto != 'sin_imagen') {
        img = 'img/1/' + elemento.foto;
    }
    var cuerpo = '';
    cuerpo = ' <div class="items">' +
        '<div class="item-content">' +
        '<div class="product-info">' +
        ' <img src="' + img + '" alt="avatar">' +
        '<div class="user-meta-info">' +
        '<a  class="btn btn-soft-success btn-rounded  ">' + elemento.nombre + '</a>' +
        '<p class="product-category-addr"><span>Stock: </span>' + elemento.cantidad + '</p>' +

        ' </div>' +
        '</div>' +
        '<div class="product-price">' +
        '<p class="product-category-addr"><span>precio: </span>' + elemento.precio + '</p><br>' +
        ' </div>' +

        ' <div class="action-btn">' +
        ' <a data-producto="' + elemento.id + '" class="btn btn-success font-20 agregar"><i class="las la-check-double"></i></a>' +
        '</div>' +
        '</div>' +
        '</div>';
    $("#productos_").append(cuerpo);
}

function pintar_paginador() {
    let cuerpo = '';
    cuerpo = '<div class="pagination p13 text-center w-100 mt-4">' +
        ' <ul class="mx-auto">' +
        '<a href="#" class="prev">' +
        ' <li>Prev</li>' +
        ' </a>' +
        ' <a class="is-active" href="#">' +
        '  <li>1</li>' +
        '</a>' +
        '<a href="#">' +
        ' <li>2</li>' +
        '</a>' +
        '<a href="#">' +
        ' <li>3</li>' +
        ' </a>' +
        '<a href="#" class="next">' +
        ' <li>Next</li>' +
        ' </a>' +
        '</ul>' +
        '</div>';
    $("#productos_").append(cuerpo);
}


$(document).on('click', '.agregar', function(e) {
    let t = this.dataset.producto
    let producto = productos.find(x => x.id == t);
    producto.contador = contador;
    cargar_detalle(producto); 
    sumar_total();

});



function cargar_detalle(elemento) {
    let cuerpo = '';
    cuerpo = '<tr id="t' + elemento.contador + '">' +
        '<td>' + elemento.nombre + '</td>' +
        '<td><input id="c' + elemento.contador + '" class="form-control cantidad" data-cantidad="' + elemento.contador + '" type="number" value=1></td>' +
        '<td><input id="cu' + elemento.contador + '" class="form-control costo_un" data-costo_un="' + elemento.contador + '" type="number" value=' + elemento.precio + '></td>' +
        '<td><input id="s' + elemento.contador + '" class="form-control subtotal" data-subtotal="' + elemento.contador + '" type="number" value=' + elemento.precio + '></td>' +
        '<td><a data-eliminar="' + elemento.contador + '" class="btn btn-danger eliminar"><i class="fa fa-trash"></i></a></td>' +
        '</tr>'
    $("#tabla").append(cuerpo);
    detalle_productos.push(elemento);
    contador++;
}
$(document).on('change keyup', '.cantidad', function(e) {
    let id = this.dataset.cantidad;
    let cantidad = this.value;
    let costo_un = $("#cu" + id).val();
    let subtotal = cantidad * costo_un;
    $("#s" + id).val(subtotal);
    sumar_total();


});
$(document).on('change keyup', '.costo_un', function(e) {
    let id = this.dataset.costo_un;
    let costo_un = this.value;
    let cantidad = $("#c" + id).val();
    let subtotal = costo_un * cantidad;
    $("#s" + id).val(subtotal);
    sumar_total();


});

$(document).on('change keyup', '.subtotal', function(e) {
    let id = this.dataset.subtotal;
    let subtotal = this.value;
    let cantidad = $("#c" + id).val();
    let costo_un = subtotal / cantidad;
    $("#cu" + id).val(costo_un);
    sumar_total();
});
$(document).on('click', '.eliminar', function(e) {
    let t = this.dataset.eliminar;
    let index = detalle_productos.findIndex(x => x.id == t);
    detalle_productos.splice(index, 1);
    $('#t' + t).remove();
    sumar_total();

});

function sumar_total() {
    var numbers = $('.subtotal')
    var total = 0;
    for (var i = 0; i < numbers.length; i++) {
        total = total + parseFloat(numbers.eq(i).val())
    }
    $('.result').text(total)
}
$(".delete").click(function() {

    //eliminar_sucursal(this.dataset.delete)
});

$(".guardar").click(function() {
    if (detalle_productos.length > 0) {
        construir_json();

    } else {
        Snackbar.show({ text: 'No existe productos.', pos: 'top-center' });
    }

});
$(".cancelar").click(function() {
    location.href = "lista_ventas.html";
});

function construir_json() {
    let datos = {};
    var costo = 0;
    for (let index = 0; index < detalle_productos.length; index++) {
        const element = detalle_productos[index];
        element.precio = $("#cu" + element.contador).val();
        element.costo = $("#s" + element.contador).val();
        element.cantidad = $("#c" + element.contador).val();
        element.id_almacen = $("#id_almacenes").val();
        element.id_producto = element.id;
        costo += parseFloat(element.costo);
    }
    datos.id_viaje = 0;
    if (id_viaje_u > 0) {
        datos.id_viaje = id_viaje_u;
    }
    datos.productos = detalle_productos;
    datos.id_sucursal = $("#id_sucursales").val();
    if (datos.id_viaje > 0) {
        datos.id_cliente = 0;
        datos.id_responsable = $("#id_responsable").val();

    } else {
        datos.id_cliente = $("#id_cliente").val();
        datos.id_responsable = 0;
    }

    datos.fecha_venta = $("#fecha_venta").val();
    datos.tipo_venta = 1;
    datos.total = costo;
    datos.nombre = $("#nombre_input").val();
    datos.ci = $("#ci_input").val();
    datos.estado = 1;
    if (datos.tipo_venta == 1) {
        datos.saldo = 0;

    } else {
        datos.saldo = datos.total;
    }

    datos.nota = $("#nota").val();

    console.log(datos);
    insertar_venta(datos);
}

function insertar_venta(datos) {
    var enviar = JSON.stringify(datos);
    $.ajax({
        url: urlServicio + 'API_REST/insertar_venta',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                let url = 'lista_ventas.html';
                if (id_viaje_u > 0) {
                    url = 'lista_viajes_venta.html';
                }
                setTimeout(() => {
                    location.href = url;
                }, 1000);
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });
}



function limpiar() {

}

function error(data, textStatus, jqXHR) {
    $('.loader').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}