let urlServicio = "/facturacion/";
let url_pdf_facturas = "https://annyelectronica.rda-consultores.com/facturacion/FacturasPDF/factura-";
let usuario = JSON.parse(localStorage.getItem("usuario"));
var URLactual = window.location.pathname;
let pagina = URLactual.split("/facturacion/");
// const paginas_cumples = ['index.html','ventas.html'];
$(document).ready(function () {
  //crear_nav();
  if (!usuario) {
    Snackbar.show({
      text: "Usuario inactivo o sesión caducada.",
      pos: "top-center",
    });
    setTimeout(function () {
      window.location.href = "login.html";
    }, 3000);
  } else {
    let validateSession = getWithExpiry(usuario);
    if (validateSession) {
      cargar_datos_nav();
      cargar_tabla();
      verificar_permiso(pagina[1]);
    } else {
      console.log(false);
      Snackbar.show({ text: "Vuelva a Logearse por favor", pos: "top-center" });
      setTimeout(function () {
        window.location.href = "login.html";
      }, 3000);
    }
  }
});

function getWithExpiry(usuario) {
  const now = new Date();
  if (now.getTime() > usuario.expiry) {
    destroy_session_back();
    return false;
  } else {
    return true;
  }
}

function verificar_permiso(pagina_actual) {
  let datos = {
    usuario: usuario.id,
    pagina: pagina_actual,
  };
  let enviar = JSON.stringify(datos);
  console.log(enviar);
  $.ajax({
    url: urlServicio + "API_REST/verificar_permiso",
    type: "POST",
    data: enviar,
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    dataType: "json",
    success: function (data) {
      if (data.errorCode == 0) {
        if (data.msg.estado == 0) {
          localStorage.removeItem("usuario");
          Snackbar.show({ text: "Cuenta desactivada", pos: "top-center" });
          setTimeout(() => {
            window.location.href = "login.html";
          }, 1500);
        } else {
          cargar_tabla();
          if (data.msg.cumple == 1) {
            const paginas_cumples = data.msg.paginas;
            if (paginas_cumples) {
              let valor = paginas_cumples.indexOf(pagina_actual);
              if (valor != -1) {
                verificar_cumple();
              }
            }
          }
        }
      } else {
        Snackbar.show({
          text: "No tiene permisos para acceder a esta sección.",
          pos: "top-center",
        });
        //window.location.href = "principal.html";
        setTimeout(() => {
          window.location.href = "lista_ventas.html";
        }, 1500);
      }
    },
    error: error,
  });
}

function verificar_cumple() {
  let id_empresa = usuario.id_empresa;
  let fecha = moment().format("YYYY-MM-DD");
  $.ajax({
    url:
      urlServicio +
      "API_REST/cargar_cliente_cumple/" +
      id_empresa +
      "/" +
      fecha,
    type: "GET",
    // data: enviar,
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    dataType: "json",
    success: function (data) {
      if (data.errorCode == 0) {
        construir_modal_cumple();
        for (let index = 0; index < data.msg.length; index++) {
          const element = data.msg[index];
          let cuerpo =
            "<td>" +
            element.nombre +
            "</td>" +
            "<td>" +
            element.correo +
            "</td>" +
            "<td>" +
            element.telefono +
            "</td>" +
            "<td>" +
            element.nit +
            "</td>";
          $("#tcumple").append(cuerpo);
        }
        $("#modal_cumple").modal("show");
      }
    },
    error: error,
  });
}
function construir_modal_cumple() {
  let cuerpo =
    '<div class="modal fade" id="modal_cumple" tabindex="-1" role="dialog" aria-labelledby="modal_cumple" aria-hidden="true">' +
    '<div class="modal-dialog " role="document">' +
    '<div class="modal-content">' +
    '<div class="modal-header">' +
    '<h5 class="modal-title" id="apertura">Cumpleañeros</h5>' +
    '<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button> </div>' +
    '<div class="modal-body"><div class=""><div class=""><form class="" novalidate action="javascript:void(0);">' +
    '<div class="">' +
    '<table class="table table-striped">' +
    "   <thead>" +
    "       <tr>" +
    "           <th>Nombre</td>" +
    "           <th>Correo</td>" +
    "           <th>Telefono</td>" +
    "           <th>CI</td>" +
    "       </tr>" +
    "   </thead>" +
    '   <tbody id="tcumple">' +
    "   </tbody>" +
    "</table>" +
    "</div></form ></div ></div ></div >" +
    '<div class="modal-footer"><button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>' +
    "</div></div> </div> </div>";
  $(".page-wrapper").append(cuerpo);
}

function destroy_session_back() {
  $.ajax({
    url: urlServicio + "API_REST/destroy_session_user",
    type: "GET",
    success: function (d) {
      let item = JSON.parse(d);
      console.log(item);
      if (item.transaccion) {
        Snackbar.show({
          text: "Se está cerrando la sesión, espere.....",
          pos: "top-center",
        });
        localStorage.removeItem("usuario");
        setTimeout(function () {
          window.location.href = "login.html";
        }, 3000);
      } else {
        Snackbar.show({ text: "Error al cerrar sesión", pos: "top-center" });
      }
    },
    error: function (data, textStatus, jqXHR) {
      console.log(data);
      console.log(textStatus);
      console.log(jqXHR);

      $(".loader").toggle();
    },
  });
}
$(document).on("click", ".logout", function () {
  destroy_session_back();
});

function priceFormatter(data) {
  var field = this.field;
  return (
    "" +
    data
      .map(function (row) {
        return +row[field];
      })
      .reduce(function (sum, i) {
        return sum + i;
      }, 0)
      .toFixed(2)
  );
}

function mostrar_cantidad_ventas(data) {
  if (data.length > 0) {
    return "Cantidad ventas: " + data[0].cantidad_venta;
  }
}

function mostrar_cantidad_compras(data) {
  if (data.length > 0) {
    return "Cantidad compras: " + data[0].cantidad_compras;
  }
}

function mostrar_cantidad_ventas_credito(data) {
  if (data.length > 0) {
    return "Cantidad ventas: " + data[0].cantidad_venta_credito;
  }
}

function priceFormatter_cantidad_ventas(data) {
  var field = this.field;
  let id = 0;
  let total = 0;
  for (let index = 0; index < data.length; index++) {
    const element = data[index];

    if (id != element.id) {
      total = parseFloat(total) + parseFloat(element[field]);
      id = element.id;
    } else {
      id = 0;
    }
  }
  return total;
}

function error(data, textStatus, jqXHR) {
  console.log(data);
  console.log(textStatus);
  console.log(jqXHR);

  $(".caja_loader").hide();
}

function validar(letra) {
  if (parseFloat(letra.val().length) > 0) {
    letra.css("border-color", "#e5eaff");
    return true;
  } else {
    Snackbar.show({ text: "Debe llenar los campos .", pos: "top-center" });
    $(".caja_loader").hide();
    letra.css("border-color", "red");

    return false;
  }
}

function data_table_cargar(array) {
  $table.bootstrapTable("load", array);
}

function data_table_cargar_1(array, table) {
  table.bootstrapTable("load", array);
}

///////////////nav
function crear_nav() {
  let cuerpo =
    '<div class="sidebar-brand">' +
    '<a href="index.html" class="logo">' +
    '<img src="img/logo_any.png" style="border-radius: 20px;" alt="Maxwell Admin" />' +
    "</a>" +
    "</div>" +
    '<div class="sidebar-user-details">' +
    '<div class="user-profile">' +
    '<img src="img/user.png" class="profile-thumb" alt="User Thumb">' +
    '<span class="status-label"></span>' +
    "</div>" +
    '<h6 class="profile-name">Sara Landivar</h6>' +
    '<div class="profile-actions">' +
    '<a href="account-settings.html" data-toggle="tooltip" data-placement="top" title="" data-original-title="Settings">' +
    '<i class="icon-settings1"></i>' +
    "</a>" +
    '<a href="#!" class="red logout" data-toggle="tooltip" data-placement="top" title="" data-original-title="Logout">' +
    '<i class="icon-power1"></i>' +
    "</a>" +
    "</div>" +
    "</div>" +
    '<div class="sidebar-content">' +
    '<div class="sidebar-menu">' +
    "<ul>" +
    '<li class="sidebar-dropdown active">' +
    '<a href="#">' +
    '<i class="icon-home2"></i>' +
    '<span class="menu-text">Inicio</span>' +
    "</a>" +
    '<div class="sidebar-submenu">' +
    "<ul>" +
    "<li>" +
    '<a href="index.html" class="current-page">Dashboard</a>' +
    "</li>" +
    "<li>" +
    '<a href="usuarios.html">Usuarios</a>' +
    "</li>" +
    "<li>" +
    '<a href="empresa.html">Empresa</a>' +
    "</li>" +
    "<li>" +
    '<a href="sucursal.html">Sucursal</a>' +
    "</li>" +
    "<li>" +
    '<a href="almacen.html">Almacen</a>' +
    "</li>" +
    "</ul>" +
    "</div>" +
    "</li>" +
    '<li class="sidebar-dropdown">' +
    '<a href="#">' +
    '<i class="icon-calendar1"></i>' +
    '<span class="menu-text">Productos</span>' +
    "</a>" +
    '<div class="sidebar-submenu">' +
    "<ul>" +
    "<li>" +
    '<a href="productos.html">Registro de productos</a>' +
    "</li>" +
    "<li>" +
    '<a href="Kardex.html">Kardex</a>' +
    "</li>" +
    "</ul>" +
    "</div>" +
    "</li>" +
    '<li class="sidebar-dropdown">' +
    '<a href="#">' +
    '<i class="icon-layers2"></i>' +
    '<span class="menu-text">Ventas</span>' +
    "</a>" +
    '<div class="sidebar-submenu">' +
    "<ul>" +
    "<li>" +
    '<a href="ventas.html">Registro de Ventas</a>' +
    "</li>" +
    "<li>" +
    '<a href="lista_ventas.html">Lista de ventas</a>' +
    "</li>" +
    "<li>" +
    '<a href="lista_ventas_credito.html">Lista de ventas al credito</a>' +
    "</li>" +
    "<li>" +
    '<a href="clientes.html">Regitro de clientes</a>' +
    "</li>" +
    "</ul>" +
    "</div>" +
    "</li>" +
    '<li class="sidebar-dropdown">' +
    '<a href="#">' +
    '<i class="icon-book-open"></i>' +
    '<span class="menu-text">Compras</span>' +
    "</a>" +
    '<div class="sidebar-submenu">' +
    "<ul>" +
    "<li>" +
    '<a href="compras.html">Registro de compras</a>' +
    "</li>" +
    "<li>" +
    '<a href="lista_compras.html">Lista de compras</a>' +
    "</li>" +
    "<li>" +
    '<a href="proveedores.html">Registro de proveedores</a>' +
    "</li>" +
    "</ul>" +
    "</div>" +
    "</li>" +
    '<li class="sidebar-dropdown">' +
    '<a href="#">' +
    '<i class="icon-edit1"></i>' +
    '<span class="menu-text">Contabilidad</span>' +
    "</a>" +
    '<div class="sidebar-submenu">' +
    "<ul>" +
    "<li>" +
    '<a href="ingreso.html">Ingreso</a>' +
    "</li>" +
    "<li>" +
    '<a href="egreso.html">Egreso</a>' +
    "</li>" +
    "<li>" +
    '<a href="tipo_ingreso_egreso.html">Tipo ingreso/egreso</a>' +
    "</li>" +
    "</ul>" +
    "</div>" +
    "</li>" +
    '<li class="sidebar-dropdown">' +
    '<a href="#">' +
    '<i class="icon-box"></i>' +
    '<span class="menu-text">Reportes</span>' +
    "</a>" +
    '<div class="sidebar-submenu">' +
    "<ul>" +
    "<li>" +
    '<a href="reporte_ganancias.html">Reporte de ganancias</a>' +
    "</li>" +
    "<li>" +
    '<a href="reporte_ganancias_detalle.html">Reporte de ganancias detalle</a>' +
    "</li>" +
    "<li>" +
    '<a href="reporte_ventas.html">Reporte de ventas</a>' +
    "</li>" +
    "<li>" +
    '<a href="reporte_compras.html">Reporte de compras</a>' +
    "</li>" +
    "<li>" +
    '<a href="reporte_imventario.html">Reporte de inventario</a>' +
    "</li>" +
    "</ul>" +
    "</div>" +
    "</li>" +
    "</ul>" +
    "</div>" +
    "</div>";

  $("#sidebar").html(cuerpo);
}

function cargar_datos_nav() {
  let img = "img/";
  if (usuario.foto == "perfil.png") {
    $(".profile-thumb").attr("src", img + usuario.foto);
  } else {
    $(".profile-thumb").attr(
      "src",
      img + usuario.id_empresa + "/" + usuario.foto
    );
  }
  $(".profile-thumb").attr("src", img + usuario.foto);
  $(".header-actions").addClass("d-none");
  $(".profile-name").text(usuario.nombre);
  $(".correo_perfil").text(usuario.correo);
}