var $table = $('#table');
var $table_costos = $('#table_costos');
let momento_actual = moment().format('YYYY-MM-DD');
let compras = [];
let viajes = [];
let costos_t = [];
let id_viaje_edit = 0;
let momento_actual_hora = moment().format('YYYY-MM-DDTHH:mm');

$(document).ready(function() {
    //$("#load_screen").toggle();
    $("#fecha_ini").val(momento_actual);
    $("#fecha_fin").val(momento_actual);
    $("#fechallegada").val(momento_actual_hora);

    cargar_tabla();
    cargar_tipo_costo();
});
$(document).on('click', '.enviar', function() {
    $("#load_screen").toggle();
    viajes = [];
    data_table_cargar(compras);
    cargar_tabla();
});
$(document).on('click', '.add_costo', function() {
    // $("#load_screen").toggle();
    let id_viaje = this.dataset.costo;
    $("#exampleModal").modal('show');
    limpiar();
    cargar_costos(id_viaje);
});
$(document).on('click', '.finalizar', function() {
    // $("#load_screen").toggle();
    let id_viaje = this.dataset.fin;
    id_viaje_edit = id_viaje;
    $("#finalizar_modal").modal('show');

});

$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar viaje seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_viaje(t);
        }
    });
});
$(document).on('click', '.delete_costo', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_costo(t);
        }
    }); 
});

$(document).on('click', '.add', function(e) {
    location.href = 'registro_venta.html?id_viaje=' + this.dataset.add;
});
$(document).on('click', '.ver', function(e) {
    location.href = 'ver_viaje_venta.html?id_viaje=' + this.dataset.ver;
});
$(document).on('click', '.guardar_costo', function(e) {
    if (parseFloat($("#costo").val()) > 0) {
        insertar_costos();

    } else {
        Snackbar.show({ text: 'Debe ingresar un costo valido.', pos: 'top-center' });

    }
});
$(document).on('click', '.finalizar_viaje_button', function(e) {
    $("#load_screen").toggle();
    let datos = {};
    datos.id = id_viaje_edit;
    datos.fecha_destino = $("#fechallegada").val();
    let enviar = JSON.stringify(datos);
    $.ajax({
        url: urlServicio + 'API_REST/finalizar_viaje',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#load_screen").hide();

            if (d.errorCode == 0) {
                Snackbar.show({ text: 'Viaje finalizado.', pos: 'top-center' });
                $table.bootstrapTable('updateByUniqueId', {
                    id: id_viaje_edit,
                    row: {
                        estadon: 'Finalizado',
                        estado: 2,
                        fecha_destino: $("#fechallegada").val(),


                    }
                });
                $("#finalizar_modal").modal('hide');

            }
        },
        error: error
    });
});

function cargar_tipo_costo() {
    $.ajax({
        url: urlServicio + 'API_REST/cargar_tipo_costos',
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                let tipo_costos = $("#id_tipo_ingreso");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    tipo_costos.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
            }
        },
        error: error


    });
}

function cargar_tabla() {
    let fecha_ini = $("#fecha_ini").val();
    let fecha_fin = $("#fecha_fin").val();
    $.ajax({
        url: urlServicio + 'API_REST/cargar_viaje_fecha/' + 2 + '/' + fecha_ini + '/' + fecha_fin,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#load_screen").hide();

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    element.estadon = 'Finalizado';
                    if (element.estado == 1) {
                        element.estadon = 'Sin finalizar';

                    }

                    element.add_costo = '<a data-costo="' + element.id + '" data-toggle="modal"  class="font-20 text-danger add_costo"><i class="fa fa-plus"></i></a>';
                    element.add_compra = '<a data-add="' + element.id + '" class="font-20 text-primary add"><i class="fa fa-plus"></i></a>';
                    element.fin = '<a data-fin="' + element.id + '" class="font-20 text-primary finalizar"><i class="fas fa-check-double"></i></a>';
                    element.ver = '<a data-ver="' + element.id + '" class="font-20 text-primary ver"><i class="fas fa-eye"></i></a>';

                    viajes.push(element);
                }

                data_table_cargar(viajes);
            }
        },
        error: error


    });
}

function cargar_costos(id_viaje) {
    id_viaje_edit = id_viaje;
    costos_t = [];
    $table_costos.bootstrapTable('load', costos_t);
    $.ajax({
        url: urlServicio + 'API_REST/cargar_costos_viaje' + '/' + id_viaje,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    //element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete_costo"><i class="las la-trash-alt"></i></a>';

                    costos_t.push(element);
                }

                $table_costos.bootstrapTable('load', costos_t);

                //data_table_cargar(sucursales);
            }
        },
        error: error


    });
}

function insertar_costos() {
    let aray = [];
    let datos = {};

    datos.id_tipo_costos = $("#id_tipo_ingreso").val();
    datos.costo = $("#costo").val();
    datos.id_viaje = id_viaje_edit;
    datos.descripcion = $("#descripcion").val();
    datos.estado = 1;

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_costos_viaje',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                let viaje_tabla = $table.bootstrapTable('getRowByUniqueId', id_viaje_edit);
                let costos = parseFloat(viaje_tabla.costo) + parseFloat($("#costo").val());
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.tipo_costo = $("#id_tipo_ingreso option:selected").text();

                // datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete_costo"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table_costos.bootstrapTable('append', aray);

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_viaje_edit,
                    row: {

                        costo: costos,


                    }
                });
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });
}

function eliminar_costo(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_costos_viaje',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                let viaje_tabla = $table.bootstrapTable('getRowByUniqueId', id_viaje_edit);
                let costos_tabla = $table_costos.bootstrapTable('getRowByUniqueId', id_);
                let costos = parseFloat(viaje_tabla.costo) - parseFloat(costos_tabla.costo);
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_viaje_edit,
                    row: {

                        costo: costos,


                    }
                });
                $table_costos.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function eliminar_viaje(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_viaje',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });
}

function limpiar() {
    $("#costo").val('');
    $("#descripcion").val('');
}

function error(data, textStatus, jqXHR) {
    $('#load_screen').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}