var $table = $('#table');

let momento_actual = moment().format('YYYY-MM-DD');
let compras = [];
let ventas_credito = [];
let costos_t = [];
var $table_costos = $('#table_costos');
let id_venta_edit = 0;
let saldo_venta = 0;
let id_empresa = 1;
$("#fecha_ini").val(momento_actual);
$("#fecha_fin").val(momento_actual);
$("#fecha_pago_").val(momento_actual);

// $(document).ready(function() {
//     //$("#load_screen").toggle();

//     carga_tabla();

// });
$(document).on('click', '.enviar', function() {
    $("#load_screen").toggle();
    compras = [];
    data_table_cargar(compras);
    cargar_tabla();
});
$(document).on('click', '.print', function(e) {
    let t = this.dataset.print;
    window.open('imprimir_venta.html?v=' + t, '_blank');

});
$(document).on('click', '.print2', function(e) {
    let t = this.dataset.print;
    window.open('imprimir_venta_cinta.html?v=' + t, '_blank');

});
$(document).on('click', '.print_p', function(e) {
    let t = this.dataset.print;
    window.open('imprimir_pago.html?v=' + t, '_blank');
});
$(document).on('click', '.pago', function() {
    // $("#load_screen").toggle();
    let id_venta = this.dataset.pago;
    $("#exampleModal").modal('show');
    limpiar();
    cargar_costos(id_venta);
});
$(document).on('click', '.guardar_costo', function(e) {
    if (parseFloat($("#monto").val()) > 0 && parseFloat($("#monto").val()) <= saldo_venta) {
        insertar_costos();

    } else {
        Snackbar.show({ text: 'Debe ingresar un monto valido.', pos: 'top-center' });

    }
});
$(document).on('click', '.delete_costo', function(e) {
    let t = this.dataset.delete;
    let datos = $table_costos.bootstrapTable('getRowByUniqueId', t);
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_pagos(datos);
        }
    }); 
});
$(document).on('click', '.delete_venta', function(e) {
    let t = this.dataset.delete;
    let datos = $table.bootstrapTable('getRowByUniqueId', t);
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_venta(datos);
        }
    }); 
});

function cargar_tabla() {
    id_empresa = usuario.id_empresa
    let fecha_ini = $("#fecha_ini").val();
    let fecha_fin = $("#fecha_fin").val();

    $.ajax({
        url: urlServicio + 'API_REST/cargar_ventas_credito_fecha/' + fecha_ini + '/' + fecha_fin + '/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            if (d.errorCode == 0) {
                let res = d.msg;
                compras = [];
                ventas_credito = [];
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    if (element.tipo_venta == 1) {
                        element.tipo_venta_n = 'Contado';
                        element.accion = '<a data-print="' + element.id + '" class="font-20 text-danger print" ><i class="las la-print"></i></a>' +
                            '<a data-print="' + element.id + '" class=" text-warning print2" ><i class="las la-print"></i></a>' +
                            '<a data-delete="' + element.id + '" class="font-20 text-danger delete_venta" ><i class="las la-trash"></i></a>';
                        compras.push(element);

                    } else {
                        element.tipo_venta_n = 'Credito';
                        element.accion = '<a data-print="' + element.id + '" class="font-em2 text-danger print"><i class="las la-print"></i></a>' +
                            '<a data-print="' + element.id + '" class="font-em2 text-danger print2" ><i class="las la-print"></i></a>' +
                            '<a data-pago="' + element.id + '" class="font-em2 text-danger pago"><i class="fas fa-money-bill"></i></a>' +
                            '<a data-delete="' + element.id + '" class="font-em2 text-danger delete_venta"><i class="las la-trash"></i></a>';
                        ventas_credito.push(element);
                    }


                    // element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    // element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                }

                data_table_cargar_1(ventas_credito, $table);
                // data_table_cargar_1(ventas_credito, $table_credito);
            }
            $(".caja_loader").hide();

        },
        error: error


    });
}


function eliminar_venta(element) {
    var datos = {};
    datos.id_venta = element.id;
    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_venta',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {

                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', element.id);
                limpiar();
            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function cargar_costos(id_venta) {
    id_venta_edit = id_venta;
    costos_t = [];
    $table_costos.bootstrapTable('load', costos_t);
    let datos = $table.bootstrapTable('getRowByUniqueId', id_venta);
    saldo_venta = datos.saldo;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_pago_venta' + '/' + id_venta,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    element.print = '<a data-print="' + element.id + '" class="font-20 text-danger print_p"><i class="fa fa-print"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete_costo"><i class="las la-trash-alt"></i></a>';

                    costos_t.push(element);
                }

                $table_costos.bootstrapTable('load', costos_t);

                //data_table_cargar(sucursales);
            }
        },
        error: error


    });
}

function insertar_costos() {
    let aray = [];
    let datos = {};

    datos.id_venta = id_venta_edit
    datos.id_usuario = usuario.id;
    datos.fecha_pago = moment($("#fecha_pago_").val()).format('YYYY-MM-DD');
    datos.monto = $("#monto").val();
    datos.nombre = $("#nombre_").val();
    datos.ci = $("#ci_").val();
    datos.nota = $("#nota_").val();

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/guardar_pago_venta',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                let viaje_tabla = $table.bootstrapTable('getRowByUniqueId', id_venta_edit);
                let saldos = parseFloat(viaje_tabla.saldo) - parseFloat($("#monto").val());
                saldo_venta = saldos;
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.print = '<a data-print="' + d.msg + '" class="font-20 text-danger print_p"><i class="fa fa-print"></i></a>';

                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete_costo"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table_costos.bootstrapTable('append', aray);

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_venta_edit,
                    row: {

                        saldo: saldos,


                    }
                });
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });
}

function eliminar_pagos(element) {
    var datos = {};
    datos.id = element.id;
    datos.monto = element.monto;
    datos.id_venta = id_venta_edit;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_pago',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                let viaje_tabla = $table.bootstrapTable('getRowByUniqueId', id_venta_edit);
                let costos_tabla = $table_costos.bootstrapTable('getRowByUniqueId', element.id);
                let costos = parseFloat(viaje_tabla.saldo) + parseFloat(costos_tabla.monto);
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_venta_edit,
                    row: {

                        saldo: costos,


                    }
                });
                $table_costos.bootstrapTable('removeByUniqueId', element.id);
                limpiar();
            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function limpiar() {
    $("#nota_").val('');
    $("#ci_").val('');
    $("#nombre_").val('');
    $("#monto").val('');
}

function error(data, textStatus, jqXHR) {
    $('#load_screen').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}