const $btnPrint = document.querySelector("#btnPrint");
$btnPrint.addEventListener("click", () => {
    window.print();
});
let id_compra;
let urlServicio='/'
$(document).ready(function() {
    //$("#load_screen").toggle();
    let params = new URLSearchParams(location.search);
    id_compra = params.get('v');
    cargar_tabla();

});

function cargar_tabla() {

    $.ajax({
        url: urlServicio + 'API_REST/cargar_ventas_id/' + id_compra,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            $("#load_screen").hide();

            if (d.errorCode == 0) {
                let res = d.msg;
                let img;
                if(res.tipo_impresion == 0){
                    setTimeout(() => {
                        window.location.href='imprimir_venta_cinta.html?v='+id_compra;
                    }, 500);
                }
                if (res.foto != "sin_imagen") {
                    img = "img/" + res.id_empresa + "/" + res.foto;
                  $("#foto").attr('src',img);
                    $("#foto").removeClass('d-none');
                    $("#empresa").addClass('d-none');
                  }
                  $("#empresa").text(res.empresa);
                $("#NRO_COMPROBANTE").text(res.id);
                let fecha_=moment(res.fecha_venta);
                $("#fecha").text(fecha_.format('YYYY-MM-DD'));
                $("#hora").text(fecha_.format('h:mm:ss'));
                if (res.tipo_venta == 1) {
                    $("#tipo_venta").text('Venta');
                } else {
                    $("#tipo_venta").text('Credito');
                }
                if (res.id_cliente > 0) {
                    $("#cliente").text(res.cliente);
                } else {
                    $("#cliente").text(res.responsable);
                    $("#cliente_h").text('Responsable');

                }
                $("#subtotal").text(res.total);

                $("#desc").text(res.descuento);
                let total = parseFloat(res.total) - parseFloat(res.descuento);
                let cancelo = parseFloat(res.total) + parseFloat(res.cambio);
                $("#total").text(total.toFixed(2));
                $("#cancelo").text(cancelo.toFixed(2));
                $("#cambio").text(res.cambio);
                $("#nota").text(res.nota);
                console.log(res);
                cargar_detalle(res.detalle);
            }
        },
        error: error


    });
}
$("#imprimir").click(function() {
    cargarpdf();
});

function cargar_detalle(array) {
    let cuerpo = '';
    let table = $('#productos');
    for (let index = 0; index < array.length; index++) {
        const element = array[index];
        let subtotal = parseFloat(element.precio) * parseFloat(element.cantidad);
        cuerpo += '<tr>' +
            '<td class="description"><strong>' + element.cantidad + 'x ' + element.nombre + '</strong></td>' +
            '<td class="quantity"><strong>' + parseFloat(element.precio).toFixed(2) + '</strong></td>' +
            '<td class="price"><strong>' + subtotal.toFixed(2) + '</strong></td>' +
            '</tr>';
    }
    table.append(cuerpo);

}

function error(data, textStatus, jqXHR) {
    $('#load_screen').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}