const csrfToken = document.head.querySelector(
  "[name~=csrf-token][content]"
).content;
$(document).ready(function () {
  //$("#load_screen").toggle();
  let params = new URLSearchParams(location.search);
  const id_venta = params.get("v");
  cargar_venta(id_venta);
});

function cargar_venta(id_venta) {
  const result = $.ajax({
    url: urlServicio + "API_REST/cargar_ventas_id/" + id_venta,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (response) {
      console.log(response);
      if (response.errorCode == 0) {
        $(".caja_loader").hide();
        crearFacturaPDF(response.msg);
      }
    },
    error: error,
  });
  return result;
}

function crearFacturaPDF(dataFactura) {
  console.log(dataFactura);
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/EventoSignificativoService.php",
    type: "POST",
    data: {
      metodo: "getEstadoAnulacion",
      nro_factura: dataFactura.nro_factura,
      cuf: dataFactura.cuf,
    },
    dataType: "json",
    success: function (d) {
      console.log(d);
      if (d.estado_anulacion === "1") {
        let evento_significativo_id = d.evento_significativo_id;
        const { jsPDF } = window.jspdf;
        let pdf = new jsPDF("p", "mm", [297, 100]);
        let width = pdf.internal.pageSize.getWidth();
        let salto = 0;
        const saltoToCabecera = cabeceraFactura(pdf, width, salto, dataFactura);
        const saltoToDetalle = detalleFactura(
          pdf,
          width,
          saltoToCabecera,
          dataFactura
        );
        leyendasyQrFactura(
          pdf,
          width,
          saltoToDetalle,
          dataFactura,
          evento_significativo_id
        );

        addWaterMark(pdf);
      } else {
        let evento_significativo_id = d.evento_significativo_id;
        const { jsPDF } = window.jspdf;
        let pdf = new jsPDF("p", "mm", [297, 100]);
        let width = pdf.internal.pageSize.getWidth();
        let salto = 0;
        const saltoToCabecera = cabeceraFactura(pdf, width, salto, dataFactura);
        const saltoToDetalle = detalleFactura(
          pdf,
          width,
          saltoToCabecera,
          dataFactura
        );
        leyendasyQrFactura(
          pdf,
          width,
          saltoToDetalle,
          dataFactura,
          evento_significativo_id
        );
      }
    },
    /* complete: function () {
        addWaterMark(pdf); 
    } */
  });
}

function addWaterMark(doc) {
  var totalPages = doc.internal.getNumberOfPages();

  for (i = 1; i <= totalPages; i++) {
    doc.setPage(i);
    //doc.addImage(imgData, 'PNG', 40, 40, 75, 75);
    doc.setFontSize(50);
    doc.setTextColor("#ff0000");
    doc.text(60, doc.internal.pageSize.height - 200, "Anulado", {
      align: "center",
      angle: 30,
    });
  }

  return doc;
}

function cabeceraFactura(pdf, width, salto, dataFactura) {
  let direccion_part1;
  let direccion_part2;
  if (dataFactura.direccion_empresa.length > 33) {
    direccion_part1 = dataFactura.direccion_empresa.substring(0, 33);
    direccion_part2 = dataFactura.direccion_empresa.substring(
      33,
      dataFactura.direccion_empresa.length
    );
  } else {
    direccion_part1 = dataFactura.direccion_empresa;
    direccion_part2 = "";
  }
  let datos_empresa = {
    nombre: "NOMBRE EMPRESA",
    celular: "CELULAR EMPRESA",
    nit: "NIT DE EMPRESA",
  };
  pdf.setFontSize(9);
  salto += 4;
  pdf.text("FACTURA", width / 2, salto, { align: "center" });
  salto += 4;
  pdf.text("CON DERECHO A CRÉDITO FISCAL", width / 2, salto, "center");
  salto += 4;
  pdf.text(dataFactura.nombre_empresa, width / 2, salto, "center");
  salto += 4;
  pdf.text("" + dataFactura.sucursal, width / 2, salto, "center");
  salto += 4;
  pdf.text(
    "Nro. Punto de Venta: " + dataFactura.nro_punto_venta,
    width / 2,
    salto,
    "center"
  );
  salto += 4;
  pdf.text(direccion_part1, width / 2, salto, "center");
  salto += 4;
  pdf.text(direccion_part2, width / 2, salto, "center");
  salto += 4;
  pdf.text("Tel: " + dataFactura.telefonoEmpresa, width / 2, salto, "center");
  salto += 4;
  pdf.text(dataFactura.ciudad, width / 2, salto, "center");
  salto += 4;
  pdf.text(
    "------------------------------------------------------------------------------------------------------------------",
    width / 2,
    salto,
    "center"
  );
  salto += 4;
  pdf.text("NIT", width / 2, salto, "center");
  salto += 4;
  pdf.text("" + dataFactura.nit_empresa, width / 2, salto, "center");
  salto += 4;
  pdf.text("Factura N*", width / 2, salto, "center");
  salto += 4;
  pdf.text("" + dataFactura.nro_factura, width / 2, salto, "center");
  salto += 4;
  pdf.text("COD. AUTORIZACIÓN", width / 2, salto, "center");
  salto += 4;
  let cuf_part1 = dataFactura["cuf"].substring(0, width / 2);
  let cuf_part2 = dataFactura["cuf"].substring(width / 2, 56);
  pdf.text(cuf_part1, width / 2, salto, "center");
  salto += 3;
  pdf.text(cuf_part2, width / 2, salto, "center");
  salto += 4;
  /*  pdf.setFontSize(9); */
  pdf.text(
    "------------------------------------------------------------------------------------------------------------------",
    width / 2,
    salto,
    "center"
  );
  let nombre = dataFactura["cliente"].toUpperCase().split(" ");
  let aux = 0;
  salto += 4;
  let nomb1 = "";
  let nomb2 = "";
  let nomb3 = "";
  if (nombre.length > 1) {
    for (let index = 0; index < nombre.length; index++) {
      aux += nombre[index].length;
      if (aux < 18) {
        nomb1 += nombre[index] + " ";
      } else if (aux < 36) {
        nomb2 += nombre[index] + " ";
      } else {
        nomb3 += nombre[index] + " ";
      }
    }
    nomb1;
    pdf.text("NOMBRE/RAZÓN SOCIAL:", width * 0.03, salto);
    pdf.text(nomb1, width * 0.6, salto);
    salto += 3;
    pdf.text(nomb2, width * 0.6, salto);
    if (aux > 36) {
      salto += 4;
      pdf.text(nomb3, width * 0.6, salto);
    }
  } else {
    pdf.text("NOMBRE/RAZÓN SOCIAL:", width * 0.03, salto);
    pdf.text(dataFactura.cliente, width * 0.6, salto);
  }
  salto += 4;
  console.log(dataFactura.complemento);
  let complemento = dataFactura.complemento;
  pdf.text("NIT/CI/CEX:", width * 0.03, salto);
  pdf.text(dataFactura.nit + " " + complemento, width * 0.6, salto);
  salto += 4;
  pdf.text("COD. CLIENTE:", width * 0.03, salto);
  pdf.text(dataFactura["id_cliente"].toString(), width * 0.6, salto);
  salto += 4;
  pdf.text("FECHA DE EMISION:", width * 0.03, salto);
  pdf.text(dataFactura["fecha_venta"], width * 0.6, salto);
  salto += 4;
  return salto;
}

function getUnidadMedidaLiteral() {}

function detalleFactura(pdf, width, salto, dataFactura) {
  let totalDetalle = 0;
  console.log(dataFactura);
  pdf.text(
    "------------------------------------------------------------------------------------------------------------------",
    width / 2,
    salto,
    "center"
  );
  salto += 4;
  pdf.text("DETALLE", width / 2, salto, "center");
  salto += 4;
  dataFactura.detalle.forEach((producto) => {
    if (producto.nombre.toString().length > 50) {
      pdf.text(
        producto.id_producto +
          " - " +
          producto.nombre.toString().substring(0, 50),
        width * 0.05,
        salto
      );
    } else {
      pdf.text(
        producto.id_producto + " - " + producto.nombre.toString(),
        2,
        salto
      );
    }
    salto += 4;
    if (producto.nombre.toString().length > 50) {
      pdf.text(
        producto.nombre
          .toString()
          .substring(50, producto.nombre.toString().length),
        width * 0.05,
        salto
      );
      salto += 4;
    }
    pdf.text(
      "Unidad de Medida: " + producto.medida_literal.toString(),
      width * 0.05,
      salto
    );
    salto += 4;
    let _cantidad = parseFloat(producto.cantidad).toFixed(2);
    pdf.text(
      _cantidad.toString() +
        " X " +
        producto.precio.toString() +
        " - " +
        parseFloat(_cantidad * producto.descuento_item)
          .toFixed(2)
          .toString(),
      width * 0.05,
      salto
    );
    pdf.text(
      parseFloat(
        _cantidad * producto.precio - producto.descuento_item * _cantidad
      )
        .toFixed(2)
        .toString(),
      width * 0.85,
      salto
    );
    salto += 5;
    totalDetalle +=
      _cantidad * producto.precio - producto.descuento_item * _cantidad;
  });

  pdf.text(
    "------------------------------------------------------------------------------------------------------------------",
    width / 2,
    salto,
    "center"
  );
  salto += 4;
  pdf.text(
    "                                         Subtotal Bs.",
    width * 0.1,
    salto
  );
  pdf.text(parseFloat(totalDetalle).toFixed(2).toString(), width * 0.85, salto);
  salto += 4;
  pdf.text(
    "                                     Descuento Bs.",
    width * 0.1,
    salto
  );
  let descuento = parseFloat(dataFactura["descuento"]);
  pdf.text(descuento.toString(), width * 0.85, salto);
  salto += 4;
  pdf.text(
    "                                              Total Bs.",
    width * 0.1,
    salto
  );
  let total = parseFloat(
    parseFloat(totalDetalle - dataFactura["descuento"])
  ).toFixed(2);
  pdf.text(total.toString(), width * 0.85, salto);
  salto += 4;
  pdf.text(
    "                             Monto Gift Card Bs.",
    width * 0.1,
    salto
  );
  let monto_gift_card = parseFloat(dataFactura["monto_giftcard"]).toFixed(2);
  pdf.text(monto_gift_card, width * 0.85, salto);
  salto += 4;
  pdf.text(
    "                               Monto a Pagar Bs.",
    width * 0.1,
    salto
  );
  let monto_a_pagar = parseFloat(
    totalDetalle - dataFactura["descuento"] - monto_gift_card
  ).toFixed(2);
  pdf.text(monto_a_pagar.toString(), width * 0.85, salto);
  salto += 4;
  pdf.text("          Importe Base Credito Fiscal Bs.", width * 0.1, salto);
  let importe_base_credito_fiscal = parseFloat(
    totalDetalle - dataFactura["descuento"] - monto_gift_card
  ).toFixed(2);
  pdf.text(importe_base_credito_fiscal.toString(), width * 0.85, salto);
  salto += 4;
  pdf.setFontSize(9);
  let numeroLetras = numeroALetras(monto_a_pagar, {
    plural: " Bolivianos",
    singular: " Bolivianos",
    centPlural: " centavos",
    centSingular: " centavo",
  });
  if (numeroLetras.length > 45) {
    numeroLetras_part1 = numeroLetras.substring(0, 45);
    numeroLetras_part2 = numeroLetras.substring(45, numeroLetras.length);
  } else {
    numeroLetras_part1 = numeroLetras;
    numeroLetras_part2 = "";
  }
  pdf.text("SON : " + numeroLetras_part1, 2, salto);
  salto += 4;
  pdf.text(numeroLetras_part2, 2, salto);
  salto += 4;
  return salto;
}

function leyendasyQrFactura(
  pdf,
  width,
  salto,
  dataFactura,
  evento_significativo_id
) {
  pdf.text(
    "------------------------------------------------------------------------------------------------------------------",
    width / 2,
    salto,
    "center"
  );
  //pdf.setFontSize(8);

  salto += 8;
  pdf.text('"ESTA FACTURA CONTRIBUYE AL DESARROLLO', width * 0.1, salto);
  salto += 4;
  pdf.text("        DEL PAIS EL USO ILICITO DE ESTA SERA", width * 0.1, salto);
  salto += 4;
  pdf.text('           SANCIONADO DE ACUERDO A LEY"', width * 0.1, salto);
  salto += 6;
  pdf.setFontSize(8);
  pdf.text(
    dataFactura["leyenda"].toString().substring(0, 58),
    width * 0.1,
    salto
  );
  salto += 4;
  if (dataFactura["leyenda"].toString().length > 120) {
    pdf.text(
      dataFactura["leyenda"].toString().substring(58, 120),
      width * 0.1,
      salto
    );
    salto += 4;
    pdf.text(
      dataFactura["leyenda"]
        .toString()
        .substring(120, dataFactura["leyenda"].toString().length),
      width * 0.1,
      salto
    );
    salto += 6;
  } else {
    pdf.text(
      dataFactura["leyenda"]
        .toString()
        .substring(58, dataFactura["leyenda"].toString().length),
      width * 0.1,
      salto
    );
    salto += 6;
  }

  if (evento_significativo_id === "-1") {
    pdf.setFontSize(9);
    pdf.text(
      '"Este documento es la Representación Gráfica de un',
      width * 0.1,
      salto
    );
    salto += 4;
    pdf.text(
      "Documento Fiscal Digital emitido en una modalidad de",
      width * 0.1,
      salto
    );
    salto += 4;
    pdf.text("facturación en línea”", width * 0.1, salto);
    salto += 6;
  } else {
    pdf.setFontSize(9);
    pdf.text(
      '"Este documento es la Representación Gráfica de un',
      width * 0.1,
      salto
    );
    salto += 4;
    pdf.text(
      "Documento Fiscal Digital emitido fuera de linea, verifique su",
      width * 0.1,
      salto
    );
    salto += 4;
    pdf.text("envio con su proveedor o en la pagina web", width * 0.1, salto);
    salto += 4;
    pdf.text("www.impuestos.gob.bo”", width * 0.1, salto);
    salto += 6;
  }

  const QRValue =
    "https://pilotosiat.impuestos.gob.bo/consulta/QR?nit=" +
    dataFactura["nit_empresa"] +
    "&cuf=" +
    dataFactura["cuf"] +
    "&numero=" +
    dataFactura.nro_factura +
    "&t=" +
    1;

  var qr = new QRious({
    element: document.getElementById("codigoQRCanvas"),
    value: QRValue,
    size: 128,
  });
  var qrSVG = qr.toDataURL("image/svg+xml");

  // Crear una imagen y asignar la imagen SVG como fuente
  var img = new Image();
  img.onload = function () {
    var canvas = document.createElement("canvas");
    canvas.width = img.width;
    canvas.height = img.height;
    var context = canvas.getContext("2d");
    context.drawImage(img, 0, 0);
    var qrImage = canvas.toDataURL("image/jpeg");
    // Insertar la imagen del código QR en el documento PDF
    pdf.addImage(qrImage, "PNG", width * 0.25, salto + 4, 50, 50); // Ajusta las coordenadas y el tamaño según tus necesidades
    var base64 = pdf.output("datauristring");
    var iframe = document.createElement("iframe");
    iframe.src = base64;
    iframe.width = "100%";
    iframe.height = "100%";
    var contenedorPDF = document.getElementById("contenedor-pdf");
    contenedorPDF.appendChild(iframe);
  };
  img.src = qrSVG;
}
