let id_compra;
$(document).ready(function() {
    let params = new URLSearchParams(location.search);
    id_compra = params.get('v');


});
function cargarpdf() {
    var imprimir = document.getElementById('pdf2');
    const $elementoParaConvertir = imprimir; // <-- Aquí puedes elegir cualquier elemento del DOM
    html2pdf()
        .set({
            margin: 1,
            filename: 'documento.pdf',
            image: {
                type: 'jpeg',
                quality: 1
            },
            html2canvas: {
                scale: 4, // A mayor escala, mejores gráficos, pero más peso
                letterRendering: true,
            },
            jsPDF: {
                unit: "mm",
                format: "a4",
                orientation: 'portrait' // landscape o portrait
            }
        })
        .from($elementoParaConvertir).toPdf().get('pdf').then(function(pdfObj) {
            // pdfObj has your jsPDF object in it, use it as you please!
            // For instance (untested):
            // pdfObj.autoPrint();
            window.open(pdfObj.output('bloburl'), '_blank').print();
        }).catch(err => console.log(err));
    // .save()
    // .catch(err => console.log(err));
}
function cargar_tabla() {

    $.ajax({
        url: urlServicio + 'API_REST/cargar_ventas_id/' + id_compra,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#load_screen").hide();

            if (d.errorCode == 0) {
                let res = d.msg;
                let img;
                if(res.tipo_impresion == 1){
                    setTimeout(() => {
                        window.location.href='imprimir_venta_mini.html?v='+id_compra;
                    }, 500);
                }
                if (res.foto != "sin_imagen") {
                    img = "img/" + res.id_empresa + "/" + res.foto;
                  $("#foto").attr('src',img);
                    $("#foto").removeClass('d-none');
                    $("#empresa").addClass('d-none');
                  }
                  $("#empresa").text(res.empresa);
                $("#NRO_COMPROBANTE").text(res.id);
                let fecha_=moment(res.fecha_venta);
                $("#fecha").text(fecha_.format('YYYY-MM-DD'));
                $("#hora").text(fecha_.format('h:mm:ss'));
                if (res.tipo_venta == 1) {
                    $("#tipo_venta").text('Venta');
                } else {
                    $("#tipo_venta").text('Credito');
                }
                if (res.id_cliente > 0) {
                    $("#cliente").text(res.cliente);
                } else {
                    $("#cliente").text(res.responsable);
                    $("#cliente_h").text('Responsable');

                }
                $("#subtotal").text(res.total);

                $("#desc").text(res.descuento);
                let total = parseFloat(res.total) - parseFloat(res.descuento);
                let cancelo = parseFloat(res.total) + parseFloat(res.cambio);
                $("#total").text(total.toFixed(2));
                $("#cancelo").text(cancelo.toFixed(2));
                $("#cambio").text(res.cambio);
                $("#nota").text(res.nota);

                cargar_detalle(res.detalle);
            }
        },
        error: error


    });
}
$("#imprimir").click(function() {
    cargarpdf();
});

function cargar_detalle(array) {
    let cuerpo = '';
    let table = $('#productos');
    for (let index = 0; index < array.length; index++) {
        const element = array[index];
        let subtotal = parseFloat(element.precio) * parseFloat(element.cantidad);
        cuerpo += '<tr>' +
            '<td class="text-break"><strong>' + element.cantidad + 'x ' + element.nombre + '</strong></td>' +
            '<td class="text-right"><strong>' + parseFloat(element.precio).toFixed(2) + '</strong></td>' +
            '<td class="text-right"><strong>' + subtotal.toFixed(2) + '</strong></td>' +
            '</tr>';
    }
    table.append(cuerpo);

}

function error(data, textStatus, jqXHR) {
    $('#load_screen').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}