let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
$(document).ready(function() {
    cargar_tipo_costo();
    cargar_sucursales();
});
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});
$("#id_sucursales").change(function() {
    $table.bootstrapTable('removeAll');
    cargar_tabla();
});

function cargar_tipo_costo() {
    let id_empresa = 1;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_tipo_costos',
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_tipo_ingreso");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
            }
        },
        error: error


    });
}

function cargar_sucursales() {
    let id_empresa = 1;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_sucursal/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_sucursales");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
                cargar_tabla();
            }
        },
        error: error


    });
}

function cargar_tabla() {
    let id_sucursal = $("#id_sucursales").val();
    $.ajax({
        url: urlServicio + 'API_REST/cargar_costos',
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                    sucursales.push(element);
                }

                data_table_cargar(sucursales);
            }
        },
        error: error


    });
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    agregar_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_sucursal(t);
        }
    }); 
});
$(".delete").click(function() {

    //eliminar_sucursal(this.dataset.delete)
});

function agregar_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#id_tipo_ingreso").val(datos.id_tipo_costos);
    $("#id_sucursal").val(datos.id_sucursal);
    $("#costo").val(datos.costo);
    $("#descripcion").val(datos.descripcion);

    $('html, body').animate({
        scrollTop: $("#id_tipo_ingreso").offset().top - 100
    }, 500);
}
$(".guardar").click(function() {
    if (id_sucursal > 0) {
        actualizar_sucursal();
    } else {
        insertar_sucursal();
    }
});
$(".cancelar").click(function() {
    limpiar();
});

function insertar_sucursal() {
    let aray = [];
    let datos = {};

    datos.id_tipo_costos = $("#id_tipo_ingreso").val();
    datos.costo = $("#costo").val();
    datos.id_viaje = 0;
    datos.descripcion = $("#descripcion").val();
    datos.estado = 1;

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_costos_viaje',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.tipo_costo = $("#id_tipo_ingreso option:selected").text();

                datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });
}

function actualizar_sucursal() {
    var datos = {};
    datos.id = id_sucursal;
    datos.id_tipo_costos = $("#id_tipo_ingreso").val();
    datos.id_sucursal = $("#id_sucursales").val();
    datos.costo = $("#costo").val();
    datos.descripcion = $("#descripcion").val();

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_costos_viaje',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_sucursal,
                    row: {
                        tipo_costo: $("#id_tipo_ingreso option:selected").text(),
                        costo: $("#costo").val(),
                        nombre: $("#nombre").val(),
                        descripcion: $("#descripcion").val()

                    }
                });
                limpiar();
            } else {
                limpiar();
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function eliminar_sucursal(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_ingreso_egreso',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function limpiar() {
    id_sucursal = 0;
    $("#monto").val('');
    $("#fecha_ingreso").val('');
    $("#descripcion").val('');
}

function error(data, textStatus, jqXHR) {
    $('.loader').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}