let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
let productos = [];
let detalle_productos = [];
let contador = 0;
let id_viaje_u = 0;
let almacenes = [];
let id_empresa = 1;
$("#fecha_ingreso").val(moment().format('YYYY-MM-DD'));
$(".fecha_modal").text(moment().format('YYYY-MM-DD'));
// $(document).ready(function() {
//     let params = new URLSearchParams(location.search);
//     id_viaje_u = params.get('id_viaje');


//     cargar_sucursales();

// });
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});
$("#fecha_ingreso").change(function() {
    $(".fecha_modal").text(this.value);
});


$("#id_sucursales").change(function() {
    id_sucursal = this.value;
    $(".caja_loader").show();

    cargar_almacen();
});

function cargar_tabla() {
    id_empresa = usuario.id_empresa;

    $.ajax({
        url: urlServicio + 'API_REST/cargar_sucursal/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_sucursales");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
                cargar_almacen();
                cargar_proveedor();

            }
        },
        error: error


    });
}

function cargar_almacen() {
    let id_sucursal = $("#id_sucursales").val();
    $("#id_almacenes").html('<option value="0">Seleccione almacén</option>');
    $.ajax({
        url: urlServicio + 'API_REST/cargar_almacen/' + id_sucursal,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();


            if (d.errorCode == 0) {
                let res = d.msg;
                almacenes = res;
                var sucursales = $("#id_almacenes");

                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
            }
        },
        error: error


    });
}


function cargar_proveedor() {

    $.ajax({
        url: urlServicio + 'API_REST/cargar_proveedor/' + usuario.id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_proveedores");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }

            }
            cargar_productos();
        },
        error: error


    });
}


function cargar_productos() {
    $.ajax({
        url: urlServicio + 'API_REST/cargar_productos/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();
            if (d.errorCode == 0) {
                let res = d.msg;
                productos = res;
                $("#productos_").html('');
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    pintar_productos(element);
                }
            } else {
                $("#productos_").html('<h4 class="text-center">No existe productos</h4>');
            }


        },
        error: error


    });
}

function pintar_productos(elemento) {
    let img = 'img/500.png';
    if (elemento.foto != 'sin_imagen') {
        img = 'img/' + id_empresa + '/' + elemento.foto;
    }
    var cuerpo = '';
    cuerpo = ' <div class="items">' +
        '<div class="item-content">' +
        '<div class="product-info">' +
        ' <img src="' + img + '" alt="avatar">' +
        '<div class="user-meta-info">' +
        '<p class="d-none"><span>Codigo_barra: </span>' + elemento.cod_barra + '</p>' +
        '<a  class="btn btn-soft-success btn-rounded  ">' + elemento.nombre + '</a>' +
        ' </div>' +
        '</div>' +
        '<div class="product-price">' +
        '<p class="product-category-addr"><span>precio: </span>' + elemento.precio + '</p>' +
        ' </div>' +

        ' <div class="action-btn">' +
        ' <a data-producto="' + elemento.id + '" class="btn btn-success font-20 agregar"><i class="las la-check-double"></i></a>' +
        '</div>' +
        '</div>' +
        '</div>';
    $("#productos_").append(cuerpo);
}

function pintar_paginador() {
    let cuerpo = '';
    cuerpo = '<div class="pagination p13 text-center w-100 mt-4">' +
        ' <ul class="mx-auto">' +
        '<a href="#" class="prev">' +
        ' <li>Prev</li>' +
        ' </a>' +
        ' <a class="is-active" href="#">' +
        '  <li>1</li>' +
        '</a>' +
        '<a href="#">' +
        ' <li>2</li>' +
        '</a>' +
        '<a href="#">' +
        ' <li>3</li>' +
        ' </a>' +
        '<a href="#" class="next">' +
        ' <li>Next</li>' +
        ' </a>' +
        '</ul>' +
        '</div>';
    $("#productos_").append(cuerpo);
}


$(document).on('click', '.agregar', function(e) {
    let t = this.dataset.producto
    let producto = productos.find(x => x.id == t);
    if ($("#id_merma").val() == 1) {
        if (detalle_productos.length > 0) {

            Snackbar.show({ text: 'No se puede agregar mas productos en merma.', pos: 'top-center' });

        } else {
            producto.contador = contador;
            cargar_detalle(producto); 
            sumar_total();
        }
    } else {
        producto.contador = contador;
        cargar_detalle(producto); 
        sumar_total();
    }

});

function agregar_por_codigo(cod_barra) {
    let producto = productos.find(x => x.cod_barra == cod_barra);
    producto.contador = contador;
    cargar_detalle(producto);
    sumar_total();
}

function crear_select_almacen(array) {
    let cuerpo = '';
    for (let index = 0; index < array.length; index++) {
        const element = array[index];
        cuerpo += '<option value="' + element.id + '">' + element.nombre + ' Sucursal: ' + element.sucursal + '</option>';
    }
    return cuerpo;
}
function validarNegativos(campo) {

    if (campo < 0) {
        Snackbar.show({ text: 'No se puede agregar negativos', pos: 'top-center' });
        return
    }
}

function cargar_detalle(elemento) {
    let detalle = {};
    detalle.contador = contador;
    detalle.id_producto = elemento.id;
    detalle.nombre = elemento.nombre;
    let date = moment().format('YYYY-MM-DD');
    let cuerpo = '';
    cuerpo = '<tr id="t' + detalle.contador + '">' +
        '<td><input class="form-control " id="l' + detalle.contador + '" type="text" value="lote 1"></td>' +
        '<td>' + detalle.nombre + '</td>' +

        '<td><input id="c' + detalle.contador + '" class="form-control cantidad" min="0" max="100000000000000000000"' +
        ' oninput="validarNegativos(this.value)"' +
        ' data-cantidad="' + detalle.contador + '" type="number" value=1></td>' +
        '<td><input id="cu' + detalle.contador + '" class="form-control costo_un" min="0"' +
        ' max="100000000000000000000" oninput="validarNegativos(this.value)" data-costo_un="' + detalle.contador + '" type="number" value=1></td>' +
        '<td><input id="s' + detalle.contador + '" class="form-control subtotal" min="0" max="100000000000000000000"' +
        ' oninput="validarNegativos(this.value)" data-subtotal="' + detalle.contador + '" type="number" value=1></td>' +
        '<td><input id="f' + detalle.contador + '" class="form-control fecha" data-fecha="' + detalle.contador + '" type="date" value=' + date + '></td>' +
        '<td><a data-eliminar="' + detalle.contador + '" class="btn btn-danger eliminar"><i class="fa fa-trash"></i></a></td>' +
        '</tr>'
    let productoFind = detalle_productos.find(x => x.id_producto === elemento.id);

    if (typeof (productoFind) == 'undefined') {
        $("#tabla").append(cuerpo);
        detalle_productos.push(detalle);
        contador++;
    } else {
        Snackbar.show({ text: 'El producto ya existe', pos: 'top-center' });
    }
    /*$("#tabla").append(cuerpo);
    detalle_productos.push(detalle);*/
    contador++;
}
$(document).on('change keyup', '.cantidad', function(e) {
    let id = this.dataset.cantidad;
    let cantidad = this.value;
    let costo_un = $("#cu" + id).val();
    let subtotal = cantidad * costo_un;
    $("#s" + id).val(subtotal);
    sumar_total();


});
$(document).on('change keyup', '.costo_un', function(e) {
    let id = this.dataset.costo_un;
    let costo_un = this.value;
    let cantidad = $("#c" + id).val();
    let subtotal = costo_un * cantidad;
    $("#s" + id).val(subtotal);
    sumar_total();


});
$("#id_merma").on('change', function() {
    detalle_productos = [];
    $("#tabla").html('');
});
$(document).on('change keyup', '.subtotal', function(e) {
    let id = this.dataset.subtotal;
    let subtotal = this.value;
    let cantidad = $("#c" + id).val();
    let costo_un = subtotal / cantidad;
    $("#cu" + id).val(costo_un);
    sumar_total();
});
$(document).on('click', '.eliminar', function(e) {
    let t = this.dataset.eliminar;
    let index = detalle_productos.findIndex(x => x.contador == t);
    detalle_productos.splice(index, 1);
    $('#t' + t).remove();
    sumar_total();

});

function sumar_total() {
    var numbers = $('.subtotal')
    var total = 0;
    for (var i = 0; i < numbers.length; i++) {
        total = total + parseFloat(numbers.eq(i).val())
    }
    $('.result').text(total)
}
$(".delete").click(function() {

    //eliminar_sucursal(this.dataset.delete)
});

$(".guardar").click(function() {
    if (detalle_productos.length > 0) {
        construir_json();

    } else {
        Snackbar.show({ text: 'No existe productos.', pos: 'top-center' });
    }

});
$(".cancelar").click(function() {

});

function validarCampos() {
    console.log($("#id_proveedores").val())
    if (
        $("#fecha_ingreso").val() == "" ||
        $("#id_sucursales").val() == 0 ||
        $("#id_almacenes").val() == 0 ||
        $("#id_proveedores").val() == 0 ||
        $("#id_proveedores").val() == "" ||
        $("#id_proveedores").val() == null ||
        $("#idtipo").val() == 0 ||
        $("#descripcion").val() == ""
    ){
        Snackbar.show({ text: 'Todos los campos son obligatorios.', pos: 'top-center' });
        return false;
    } else {
        return true;
    }
}

function construir_json() {
    if(validarCampos()===false){
        return;
    }
    let datos = {};
    var costo = 0;
    for (let index = 0; index < detalle_productos.length; index++) {
        const element = detalle_productos[index];
        element.costo = $("#s" + element.contador).val();
        element.cantidad = $("#c" + element.contador).val();
        element.lote = $("#l" + element.contador).val();
        element.id_almacen = $("#id_almacenes").val();
        element.fecha_vencimiento = $("#f" + element.contador).val();
        costo += parseFloat(element.costo);
    }
    datos.productos = detalle_productos;
    datos.costo = costo;
    datos.fecha_ingreso = $("#fecha_ingreso").val();
    datos.id_sucursal = $("#id_sucursales").val();
    datos.id_almacen = $("#id_almacenes").val();
    datos.id_proveedor = $("#id_proveedores").val();
    datos.id_tipo_ingreso = $("#id_tipo").val();
    datos.descripcion = $("#descripcion").val();
    datos.saldo=0;
    if($("#id_tipo").val()==2){
    datos.saldo=costo;
    }

    datos.id_usuario = usuario.id;

    datos.id_viaje = 0;

    if (productos.length > 0 && parseInt($("#id_almacenes").val())>0 ) {

        insertar_ingreso(datos);
    } else {
        Snackbar.show({ text: 'No existe productos, debe seleccionar almacen', pos: 'top-center' });
    }
}



function insertar_ingreso(datos) {
    var enviar = JSON.stringify(datos);
    $(".caja_loader").show();

    $.ajax({
        url: urlServicio + 'API_REST/insertar_ingreso',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                setTimeout(() => {
                    location.href = "lista_ingresos.html";
                }, 1000);
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }
            $(".caja_loader").hide();

        },
        error: error



    });
}



function limpiar() {

}

function error(data, textStatus, jqXHR) {
    $('.caja_loader').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}