let clientes = [];
var $table = $('#table');
let id_cliente = 0;
$(document).ready(function() {
    cargar_tabla();
});
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});

function cargar_tabla() {
    let id = 2;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_cliente_chofer/' + id,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                    clientes.push(element);
                }

                data_table_cargar(clientes);
            }
        },
        error: error


    });
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_cliente = t;
    agregar_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar cliente?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_cliente(t);
        }
    }); 
});
$(".delete").click(function() {

    //eliminar_cliente(this.dataset.delete)
});

function agregar_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#nombre").val(datos.nombre);
    $("#nit").val(datos.nit);
    $("#telefono").val(datos.telefono);
    $("#direccion").val(datos.direccion);

    $('html, body').animate({
        scrollTop: $("#nombre").offset().top - 100
    }, 500);
}
$(".guardar").click(function() {
    if (id_cliente > 0) {
        if (validar($("#nombre")) && validar($("#nit")) && validar($("#telefono"))&& validar($("#direccion"))) {

            actualizar_cliente();

        }
      
    } else {
        if (validar($("#nombre")) && validar($("#nit")) && validar($("#telefono"))&& validar($("#direccion"))) {

            insertar_cliente();
        }
      
    }
});
$(".cancelar").click(function() {
    limpiar();
});

function insertar_cliente() {
    let aray = [];
    let datos = {};
    datos.nombre = $("#nombre").val();
    datos.nit = $("#nit").val();
    datos.telefono = $("#telefono").val();
    datos.direccion = $("#direccion").val();
    datos.id_tipo_cliente=2;

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_cliente',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });
}

function actualizar_cliente() {
    var datos = {};
    datos.id = id_cliente;
    datos.nombre = $("#nombre").val();
    datos.nit = $("#nit").val();
    datos.telefono = $("#telefono").val();
    datos.direccion = $("#direccion").val();


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_cliente_chofer',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_cliente,
                    row: {

                        nombre: $("#nombre").val(),
                        nit: $("#nit").val(),
                        telefono: $("#telefono").val(),
                        direccion: $("#direccion").val()

                    }
                });
                limpiar();
            } else {
                limpiar();
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function eliminar_cliente(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_cliente_chofer',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function limpiar() {
    id_cliente = 0;
    $("#nombre").val('');
    $("#nit").val('');
    $("#telefono").val('');
    $("#direccion").val('');
}

function error(data, textStatus, jqXHR) {
    $('.loader').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}