let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
let id_empresa = 0;
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});


function cargar_tabla() {
    id_empresa = usuario.id_empresa;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_sucursal/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.caja_loader').hide();

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_sucursales");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
                cargar_almacen();
            }
        },
        error: error


    });
}

function cargar_almacen() {
    $.ajax({
        url: urlServicio + 'API_REST/cargar_almacen_todos/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                    sucursales.push(element);
                }

                data_table_cargar(sucursales);
            }
        },
        error: error


    });
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    agregar_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_almacen(t);
        }
    }); 
});


function agregar_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#nombre").val(datos.nombre);
    $("#descripcion").val(datos.descripcion);
    $("#id_sucursales").val(datos.id_sucursal);
    $('html, body').animate({
        scrollTop: $("#nombre").offset().top - 100
    }, 500);
}
$(".guardar").click(function() {
    if (id_sucursal > 0) {
        if (validar($("#nombre")) && validar($("#descripcion")) && validar($("#id_sucursales"))) {

            actualizar_almacen();

        }
    } else {
        if (validar($("#nombre")) && validar($("#descripcion")) && validar($("#id_sucursales"))) {

            insertar_almacen();
        }
    }
});
$(".cancelar").click(function() {
    limpiar();
});


function insertar_almacen() {
    let aray = [];
    let datos = {};
    datos.id_sucursal = $("#id_sucursales").val();
    datos.sucursal = $("#id_sucursales option:selected").text();
    datos.nombre = $("#nombre").val();
    datos.descripcion = $("#descripcion").val();

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_almacen',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: error



    });
}

function actualizar_almacen() {
    var datos = {};
    datos.id = id_sucursal;
    datos.nombre = $("#nombre").val();
    datos.descripcion = $("#descripcion").val();
    datos.id_sucursal = $("#id_sucursales").val();
    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_almacen',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_sucursal,
                    row: {

                        nombre: $("#nombre").val(),
                        descripcion: $("#descripcion").val(),
                        sucursal: $("#id_sucursales option:selected").text(),
                        id_sucursal: $("#id_sucursales").val(),

                    }
                });
                limpiar();
            } else {
                limpiar();
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: error



    });


}

function eliminar_almacen(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_almacen',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: error



    });


}

function limpiar() {
    id_sucursal = 0;
    $("#nombre").val('');
    $("#nombre_factura").val('');
    $("#descripcion").val('');
}