let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
let url_imagen = 'img/';
let id_empresa = 0;
// $(document).ready(function() {
//     cargar_tabla();
// });
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});
$("#img").click(function() {
    $("#fimagen").click();
});
$("#fimagen").change(function() {
    var ext = this.value.match(/\.([^\.]+)$/)[1];
    switch (ext) {
        case 'jpg':
        case 'jpeg':
        case 'bmp':
        case 'png':
        case 'tif':
            var file = this.files[0];
            var reader = new FileReader();
            reader.onload = function(e) {
                var data = e.target.result;
                $('#img').attr("src", data);
                actualizar_imagen(data)
            };
            reader.readAsDataURL(file);
            break;
        default:
            $('#img').attr("src", "img/perfil.png");
            alert('Imagen no soportada');
            imagen = 'sin_imagen';

            this.value = '';
    }

});

function cargar_tabla() {
    let id = usuario.id;
    id_empresa = usuario.id_empresa;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_usuarios_u/' + id,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let datos = d.msg;

                $("#nombre").val(datos.nombre);
                $("#correo").val(datos.correo);
                $("#pass").val(datos.pass);
                $("#telefono").val(datos.telefono);
                $("#cargo").val(datos.cargo);
                $("#salario").val(datos.salario);
                $("#rol").val(datos.rol);
                if (datos.foto == 'perfil.png') {
                    $("#img").attr("src", url_imagen + datos.foto);
                    $('.profile-thumb').attr("src", url_imagen + datos.foto);

                } else {
                    $("#img").attr("src", url_imagen + id_empresa + '/' + datos.foto);
                    $('.profile-thumb').attr("src", url_imagen + id_empresa + '/' + datos.foto);

                }
            }
            $(".caja_loader").hide();

        },
        error: error


    });
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    agregar_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_sucursal(t);
        }
    }); 
});
$(".delete").click(function() {

    //eliminar_sucursal(this.dataset.delete)
});

function agregar_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#nombre").val(datos.nombre);
    $("#nombre_factura").val(datos.nombre_factura);
    $("#direccion").val(datos.direccion);

    $('html, body').animate({
        scrollTop: $("#nombre").offset().top - 100
    }, 500);
}
$("#guardar").click(function() {

    actualizar_sucursal();

});
$(".cancelar").click(function() {
    limpiar();
});


function actualizar_sucursal() {
    var datos = {};
    datos.nombre = $("#nombre").val();
    datos.pass = $("#pass").val();
    datos.telefono = $("#telefono").val();
    datos.id = usuario.id;

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_usuario',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });



            } else {

                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: error



    });


}

function actualizar_imagen(img) {
    var datos = {};

    datos.id = usuario.id;
    datos.id_empresa = usuario.id_empresa;
    datos.foto = img;

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_usuario_img',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });

                // $(".profile-thumb").src(url_imagen + id_empresa + '/' + img);
                usuario.foto = d.msg;
                localStorage.setItem('usuario', JSON.stringify(usuario));
                $('.profile-thumb').attr("src", img);
            } else {

                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: error



    });


}

function eliminar_sucursal(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_sucursal',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: error


    });


}

function limpiar() {
    id_sucursal = 0;
    $("#nombre").val('');
    $("#nombre_factura").val('');
    $("#direccion").val('');
}