let sucursales = [];
var $table = $("#table");
let id_sucursal = 0;
const csrfToken = document.head.querySelector(
  "[name~=csrf-token][content]"
).content;

let registrarPuntoVenta = document.getElementById("registrarPuntoVenta");
//let ruta = "ServiciosSiat/PuntoVentaService.php";
let ruta = "/ServiciosSiat/PuntoVentaService/";
$(function () {
  $table.bootstrapTable("refreshOptions", {
    locale: "es-AR",
  });
});

window.onload = function () {
  $.ajax({
    url: "ServiciosSiat/PuntoVentaService.php",
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      var selectEventos = $("#punto_venta").html("");
      let eventos = d.content;

      for (let index = 0; index < d.content.length; index++) {
        const element = eventos[index];
        if (index == 0) {
          selectEventos.append(
            '<option selected value="' +
              element.codigoclasificador +
              '">' +
              element.descripcion +
              "</option>"
          );
        } else {
          selectEventos.append(
            '<option value="' +
              element.codigoclasificador +
              '">' +
              element.descripcion +
              "</option>"
          );
        }
      }
    },
    error: error,
  });
};
function llenarSelect() {
  let id_empresa = usuario.id_empresa;
  $.ajax({
    url: urlServicio + "API_REST/cargar_sucursales_puntoventa/" + id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      var sucu = $("#id_sucursales").html("");
      if (d.errorCode == 0) {
        let res = d.msg;
        sucursales = res.sucursal;

        sucu.append("<option disabled selected>Seleccione una opción</option>");

        for (let index = 0; index < res.sucursal.length; index++) {
          const element = res.sucursal[index];
          if (index == 0) {
            sucu.append(
              '<option selected value="' +
                element.codigosucursal +
                '">' +
                element.nombre +
                "</option>"
            );
          } else {
            sucu.append(
              '<option value="' +
                element.codigosucursal +
                '">' +
                element.nombre +
                "</option>"
            );
          }
        }
      }
    },
    error: error,
  });
}
function llenarTabla() {
  let id_empresa = usuario.id_empresa;
  $.ajax({
    url: urlServicio + "API_REST/cargar_puntoventa/" + id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      if (d.errorCode == 0) {
        let res = d.msg;
        let puntosVentas = [];
        for (let index = 0; index < res.length; index++) {
          const element = res[index];
          element.editar =
            '<a onclick="editarPV(' +
            element.id_puntoventa +
            ')" data-edit="' +
            element.id +
            '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
          element.eliminar =
            '<a data-delete="' +
            element.id_puntoventa +
            '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
          //sucursales.push(element);
          puntosVentas.push(element);
        }
        data_table_cargar(puntosVentas);
      }
    },
    error: error,
  });
}

function editarPV(id) {
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/PuntoVentaService.php",
    type: "POST",
    data: {
      metodo: "updatePV",
      id_punto_venta: id,
    },
    dataType: "json",
    success: function (d) {
      if (d) {
      }
    },
    error: error,
    complete: function (d) {
      if (d) {
        Snackbar.show({ text: "Punto de Venta Actualizado", pos: "top-right" });
      }
      /* loadingElem.classList.remove('d-block');
      loadingElem.classList.add('d-none');
      buttonRegistrar.disabled = false; */
      //      location.href = "PuntoVenta.html";
    },
  });
}
function cargar_tabla() {
  llenarSelect();
  llenarTabla();
}

registrarPuntoVenta.addEventListener("click", function (e) {
  var sucu = $("#id_sucursales").find(":selected").text(); //nombre de la sucursal
  var sucSeleccionada = sucursales.find((o) => o.nombre == sucu);
  let id_empresa = sucSeleccionada.id_empresa;
  let id_sucursal = sucSeleccionada.codigosucursal;
  let id_tipoventa = document.getElementById("punto_venta").value;
  let nombre_pv = document.getElementById("nombrePV").value;
  let descripcion_pv = document.getElementById("descripcionPV").value;
  let loadingElem = document.getElementById("loadingElement");
  let buttonRegistrar = document.getElementById("registrarPuntoVenta");
  //validando inputs
  if (nombre_pv == null || nombre_pv == "") {
    Snackbar.show({ text: "El nombre es requerido", pos: "top-right" });
    return;
  } else if (descripcion_pv == null || descripcion_pv == "") {
    Snackbar.show({ text: "La descripcion es requerida", pos: "top-right" });
    return;
  }
  loadingElem.classList.remove("d-none");
  loadingElem.classList.add("d-block");
  buttonRegistrar.disabled = true;
  console.log(nombre_pv + "-" + descripcion_pv);
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/PuntoVentaService.php",
    type: "POST",
    data: {
      metodo: "registroPuntoVenta",
      sucursal: id_sucursal,
      empresa: id_empresa,
      tipo_venta: id_tipoventa,
      nombre_pv: nombre_pv,
      descripcion_pv: descripcion_pv,
    },
    dataType: "json",
    success: function (d) {
    //console.log(d);
      if (!d.transaccion) {
        Snackbar.show({ text: d.msg, pos: "top-right" });
      } else {
        Snackbar.show({ text: d.msg, pos: "top-right" });
      }
      loadingElem.classList.remove("d-block");
      loadingElem.classList.add("d-none");
      buttonRegistrar.disabled = false;
      setTimeout(function () {
          location.href = "PuntoVenta.html";
        }, 3000);
    },
    error: error,
  });
});
