<?php

namespace SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services;

use \Config as ConfiguracionDB;
use App\ServiciosSiat\ConfigService;

/**
 * Clase para el servicio de Verificar Nit Valido
 * @author Patrick
 *
 */
class ServicioVerificarFactura extends ServicioSiat
{
    protected $wsdl;

    public function __construct()
    {
        $id_empresa = (new ConfigService())->getTaxesInfoUser()[1]['id'];

        $db = ConfiguracionDB::getConnection();
        $sql = "SELECT * FROM `linksin` WHERE  id_empresa=:id LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id', $id_empresa);
        $stmt->execute();
        $allLinks = $stmt->fetch(\PDO::FETCH_ASSOC);

        $linkSincronizacion = json_decode(json_encode($allLinks), true);
        $this->wsdl = $linkSincronizacion['linkcompraventa'];
    }

    public function verificacionEstadoFactura($cuf, $cuis, $cufd, $codigoPV, $codigoSucursal, $documentoSector, $emision)
    {
        $configSistema = (new ConfigService())->config;
        //$estado_emision = $emision == -1 ? '1' : '2';
        $estado_emision ='1';
        $data = [
            [
                'SolicitudServicioVerificacionEstadoFactura' => [
                    'codigoAmbiente'    => $configSistema->ambiente,
                    'codigoPuntoVenta' => $codigoPV,
                    'codigoSistema'       => $configSistema->codigoSistema,
                    'codigoSucursal'    => $codigoSucursal,
                    'nit'                 => $configSistema->nit,
                    'codigoDocumentoSector' => $documentoSector,
                    'codigoEmision' => $estado_emision,
                    'codigoModalidad' => $configSistema->modalidad,
                    'cufd'              => $cufd,
                    'cuis'              => $cuis,
                    'tipoFacturaDocumento' => "1", //siempre 1 con derecho a credito fiscal
                    'cuf'    => $cuf
                ]
            ]
        ];
        list(, $action) = explode('::', __METHOD__);
        $res = $this->callAction($action, $data);
        return  $res;
    }
}
