<?php
namespace SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Invoices\SiatInvoice;
use RobRichards\XMLSecLibs\XMLSecurityDSig;
use RobRichards\XMLSecLibs\XMLSecurityKey;
use Exception;

use \Config as ConfiguracionDB;
use App\ServiciosSiat\ConfigService;

/**
 * Clase para el servicio de Facturacion Computarizada en linea
 * @author J. Marcelo Aviles Paco
 *
 */
class ServicioFacturacionElectronica extends ServicioFacturacion
{
	protected	$wsdl = 'https://pilotosiatservicios.impuestos.gob.bo/v2/ServicioFacturacionElectronica?wsdl';
	
	protected	$privateCertFile;
	protected	$publicCertFile;

	protected function getLinkSincro()
	{
		$id_empresa = (new ConfigService())->getTaxesInfoUser()[1]['id'];

		$db = ConfiguracionDB::getConnection();
		$sql = "SELECT * FROM `linksin` WHERE  id_empresa=:id LIMIT 1";
		$stmt = $db->prepare($sql);
		$stmt->bindParam(':id', $id_empresa);
		$stmt->execute();
		$allLinks = $stmt->fetch(\PDO::FETCH_ASSOC);

		return json_encode($allLinks);
	}
	
	public function __construct($cuis = null, $cufd = null, $token = null, $endpoint = null)
	{
		$linkSincronizacion = json_decode($this->getLinkSincro(), true);
		$this->wsdl = $linkSincronizacion['linkcompraventa'];
		parent::__constructor($cuis ,$cufd ,$token,$endpoint);
		
	}
	public function setPrivateCertificateFile($filename)
	{
		if( !is_file($filename) )
			throw new Exception('PRIVATE CERTIFICATE ERROR: The certificate file "'. $filename .'" does not exists');
		$this->privateCertFile = $filename;
	}
	public function setPublicCertificateFile($filename)
	{
		if( !is_file($filename) )
			throw new Exception('PUBLIC CERTIFICATE ERROR: The certificate file does not exists');
		$this->publicCertFile = $filename;
	}
	public function signInvoice(string $xml)
	{
		if( !$this->privateCertFile || !$this->publicCertFile )
			throw new Exception('INVOICE SIGN PROCESS ERROR: Invalid certificates filenames');
		
		require_once MOD_SIAT_DIR . SB_DS . 'Libs' . SB_DS . 'xmlseclibs' . SB_DS . 'xmlseclibs.php';
		
		$doc = new \DOMDocument();
		$doc->loadXML($xml);
		$objDSig = new XMLSecurityDSig('');
		//$objDSig->setCanonicalMethod(XMLSecurityDSig::EXC_C14N);
		$objDSig->setCanonicalMethod(XMLSecurityDSig::C14N);
		$objDSig->addReference($doc, XMLSecurityDSig::SHA256, 
		[
			'http://www.w3.org/2000/09/xmldsig#enveloped-signature',
			'http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments']
		
		, ['force_uri' => true]);
		$objKey = new XMLSecurityKey(XMLSecurityKey::RSA_SHA256, array('type'=>'private'));
		$objKey->loadKey($this->privateCertFile, true);
		$objDSig->sign($objKey);
		$objDSig->add509Cert(file_get_contents($this->publicCertFile));
		$objDSig->appendSignature($doc->documentElement);
		
		return $doc->saveXML();
	}
	public function buildInvoiceXml(SiatInvoice $invoice)
	{
		$invoiceXml = $invoice->toXml(null, true)->asXML();
		
		$invoiceXml = $this->signInvoice($invoiceXml);
		return $invoiceXml;
	}
}