<?php

namespace App\ServiciosSiat; // Add the desired namespace
require __DIR__ . '/../Siat/Services/ServicioFacturacionSincronizacion.php';

use Config;
use App\ServiciosSiat\ConfigService;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioFacturacionSincronizacion;
use App\ServiciosSiat\PuntoVentaService;

class SincronizarCatalogoService
{
    public $configService;
    public $codigoCui;

    public function __construct()
    {
        $this->configService = new ConfigService();
    }
    
    public function getExistsPVEmpresa($sucursal, $empresaId, $tipoPuntoVenta)
    {
        
        $db = Config::getConnection();
        $sql = "SELECT *
        FROM puntodeventa WHERE 
        csucursal=:csucursal AND id_empresa=:id_empresa AND cpuntoventa=:puntoventa";
        $arrayData['csucursal'] = $sucursal;
        $arrayData['empresaId'] = $empresaId;
        $arrayData['puntoventa'] = $tipoPuntoVenta;
        //echo json_encode( $arrayMac );

        $stmt = $db->prepare($sql);
        /* $stmt->bindParam( ':pc', $pc );
        $stmt->bindParam( ':mac', $arrayMac[ 'mac' ] );
        */
        $stmt->bindParam(':csucursal', $arrayData['csucursal']);
        $stmt->bindParam(':id_empresa', $arrayData['empresaId']);
        $stmt->bindParam(':puntoventa', $arrayData['puntoventa']);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            return $stmt->fetch();
        } else {
            return null;
        }
    }

    
    public function obtenerCuisDB($empresa)
    {

        if (!isset($_SESSION)) {
            session_start();
        }

        $userData = json_decode($_SESSION['dataUser']);
        $userID = $userData->id;
        $pc = gethostname();
        $db = Config::getConnection();
        $estado = 1;
        $sql = "SELECT * from puntodeventa p 
        join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
        where pvu.user_id = :user_id
        and p.id_empresa = :id_empresa
        and p.estado = :estado LIMIT 1; ";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':user_id', $userID);
        $stmt->bindParam(':id_empresa', $empresa);
        $stmt->bindParam(':estado', $estado);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $responseCuis = $stmt->fetch();
            return $responseCuis;
        } else {
            $response = $this->getExistsPVEmpresa(0, $userData->id_empresa, 0);
            
            return $response;
        }
    }

    public function sincronizarListaLeyendasFactura($sucursal, $puntoventa, $empresa)
    {
        $leyendaFacturaId = null;
        $estado = 1;
        $codigoEspecial = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        //echo json_encode($codigoCui);
        
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarListaLeyendasFactura($sucursal, $puntoventa, $codigoCui['ccuis']);
        
        //echo json_encode($res);

        if ($res->RespuestaListaParametricasLeyendas->transaccion == true) {

            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricasLeyendas->listaLeyendas as $listado) {
                $sql = "INSERT INTO impuestos_leyendasfacturas
                    (idleyendasfacturas  ,codigoclasificador, descripcion, estado, codigoespecial ,id_empresa)
                    VALUES 
                    (:idleyendasfacturas ,:codigoclasificador, :descripcion, :estado,:codigoespecial,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idleyendasfacturas',     $leyendaFacturaId);
                $stmt->bindParam('codigoclasificador',     $listado->codigoActividad);
                $stmt->bindParam('descripcion',     $listado->descripcionLeyenda);
                $stmt->bindParam('estado',  $estado);
                $stmt->bindParam('codigoespecial',   $codigoEspecial);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarMensajesServicios($sucursal, $puntoventa, $empresa)
    {
        $productoServicioID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarListaMensajesServicios($sucursal, $puntoventa, $codigoCui['ccuis']);
        /* echo json_encode($res);  */

        if ($res->RespuestaListaParametricas->transaccion == true) {

            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_mensajeservicio
                    (idmensajeservicio   ,codigoclasificador, descripcion, estado, transaccion ,id_empresa)
                    VALUES 
                    (:idmensajeservicio  ,:codigoclasificador, :descripcion, :estado,:transaccion,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idmensajeservicio',     $productoServicioID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('estado',  $estado);
                $stmt->bindParam('transaccion',   $listado->transaccion);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarProductoServicios($sucursal, $puntoventa, $empresa)
    {
        $productoServicioID = null;
        $estado = 1;
        $nandina = 1;

        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarListaProductosServicios($sucursal, $puntoventa, $codigoCui['ccuis']);
        /* echo json_encode($res);  */

        if ($res->RespuestaListaProductos->transaccion == true) {

            $db = Config::getConnection();
            foreach ($res->RespuestaListaProductos->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_productoservicios
                    (idproductoservicios   ,codigoactividad, codigoproducto, descripcion, nandina ,estado, id_empresa)
                    VALUES 
                    (:idproductoservicios  ,:codigoactividad, :codigoproducto, :descripcion,:nandina,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idproductoservicios',     $productoServicioID);
                $stmt->bindParam('codigoactividad',     $listado->codigoActividad);
                $stmt->bindParam('codigoproducto',     $listado->codigoProducto);
                $stmt->bindParam('descripcion',  $listado->descripcionProducto);
                $stmt->bindParam('nandina',   $nandina);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarEventoSignificativos($sucursal, $puntoventa, $empresa)
    {
        $eventoSignificativoID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaEventosSignificativos($sucursal, $puntoventa, $codigoCui['ccuis']);

        if ($res->RespuestaListaParametricas->transaccion == true) {

            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_eventosignificativo
                    (ideventosignificativo   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:ideventosignificativo  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('ideventosignificativo',     $eventoSignificativoID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarMotivosAnulaciones($sucursal, $puntoventa, $empresa)
    {
        $motivoanulacionID = null;
        $estado = 1;


        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion($codigoCui['ccuis']);
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaMotivoAnulacion($sucursal, $puntoventa, $codigoCui['ccuis']);


        if ($res->RespuestaListaParametricas->transaccion) {

            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_motivoanulacion
                    (idmotivoanulacion   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idmotivoanulacion  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idmotivoanulacion',     $motivoanulacionID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarPaisesOrigen($sucursal, $puntoventa, $empresa)
    {
        $paisID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaPaisOrigen($sucursal, $puntoventa, $codigoCui['ccuis']);
        if ($res->RespuestaListaParametricas->transaccion == true) {

            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_paisorigen
                    (idpaisorigen   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idpaisorigen  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idpaisorigen',     $paisID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarTipoDocumentoIdentidades($sucursal, $puntoventa, $empresa)
    {
        $documentoIdentidadID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaTipoDocumentoIdentidad($sucursal, $puntoventa, $codigoCui['ccuis']);
        if ($res->RespuestaListaParametricas->transaccion == true) {
            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_documentoidentidad
                    (iddocumentoidentidad   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:iddocumentoidentidad  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('iddocumentoidentidad',     $documentoIdentidadID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarDocumentoSectores($sucursal, $puntoventa, $empresa)
    {
        $documentoSectorID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarListaActividadesDocumentoSector($sucursal, $puntoventa, $codigoCui['ccuis']);
        if ($res->RespuestaListaActividadesDocumentoSector->transaccion == true) {
            $db = Config::getConnection();
            foreach ($res->RespuestaListaActividadesDocumentoSector->listaActividadesDocumentoSector as $listado) {
                $sql = "INSERT INTO documentosector
                    (iddocumentosector    ,codigoactividad, codigodocumentosector, tipodocumentosect ,estado, id_empresa)
                    VALUES 
                    (:iddocumentosector  ,:codigoactividad, :codigodocumentosector,:tipodocumentosect,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('iddocumentosector',     $documentoSectorID);
                $stmt->bindParam('codigoactividad',     $listado->codigoActividad);
                $stmt->bindParam('codigodocumentosector',     $listado->codigoDocumentoSector);
                $stmt->bindParam('tipodocumentosect',    $listado->tipoDocumentoSector);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarTipoDocumentoSectores($sucursal, $puntoventa, $empresa)
    {
        $documentoSectorID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaTipoDocumentoSector($sucursal, $puntoventa, $codigoCui['ccuis']);
        //echo json_encode($res);
        if ($res->RespuestaListaParametricas->transaccion == true) {
            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_tipodocumentosector
                    (idtipodocumentosector   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idtipodocumentosector  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idtipodocumentosector',     $documentoSectorID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarTiposEmisiones($sucursal, $puntoventa, $empresa)
    {
        $tipoEmisionID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaTipoEmision($sucursal, $puntoventa, $codigoCui['ccuis']);
        if ($res->RespuestaListaParametricas->transaccion == true) {
            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_tipoemision
                    (idtipoemision   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idtipoemision  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idtipoemision',     $tipoEmisionID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarMetodosPagos($sucursal, $puntoventa, $empresa)
    {
        $metodopAgoID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaTipoMetodoPago($sucursal, $puntoventa, $codigoCui['ccuis']);
        if ($res->RespuestaListaParametricas->transaccion == true) {
            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_tipometodopago
                    (idtipometodopago   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idtipometodopago  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idtipometodopago',     $metodopAgoID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarTiposMonedaas($sucursal, $puntoventa, $empresa)
    {
        $monedaID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaTipoMoneda($sucursal, $puntoventa, $codigoCui['ccuis']);
        if ($res->RespuestaListaParametricas->transaccion == true) {
            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_tipomoneda
                    (idtipomoneda   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idtipomoneda  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idtipomoneda',     $monedaID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarTiposPuntosVentas($sucursal, $puntoventa, $empresa)
    {
        $tipoPuntoVentaID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaTipoPuntoVenta($sucursal, $puntoventa, $codigoCui['ccuis']);
        if ($res->RespuestaListaParametricas->transaccion == true) {
            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_tipopuntodeventa
                    (idtipopuntodeventa   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idtipopuntodeventa  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idtipopuntodeventa',     $tipoPuntoVentaID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
            //insertando un nuevo tipo punto venta
            $sql = "INSERT INTO impuestos_tipopuntodeventa
                    (idtipopuntodeventa   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idtipopuntodeventa  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
            $dataInsert["tipoPuntoVentaID"] = 0;
            $dataInsert["codigoClasificador"] = 0;
            $dataInsert["descripcion"] = "NO CORRESPONDE";
            $dataInsert["transaccion"] = "true";

            $stmt = $db->prepare($sql);
            $stmt->bindParam('idtipopuntodeventa',     $dataInsert["tipoPuntoVentaID"]);
            $stmt->bindParam('codigoclasificador',     $dataInsert["codigoClasificador"]);
            $stmt->bindParam('descripcion',     $dataInsert["descripcion"]);
            $stmt->bindParam('transaccion',    $dataInsert["transaccion"]);
            $stmt->bindParam('estado', $estado);
            $stmt->bindParam('id_empresa', $empresa);
            $stmt->execute();
        }
        return $res;
    }

    public function sincronizarTiposPuntosFacturas($sucursal, $puntoventa, $empresa)
    {
        $tipoFacturaID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaTiposFactura($sucursal, $puntoventa, $codigoCui['ccuis']);
        if ($res->RespuestaListaParametricas->transaccion == true) {
            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_tipofactura
                    (idtipofactura   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idtipofactura  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idtipofactura',     $tipoFacturaID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarUnidadesMedidas($sucursal, $puntoventa, $empresa)
    {
        $unidadMedidaID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaUnidadMedida($sucursal, $puntoventa, $codigoCui['ccuis']);
        if ($res->RespuestaListaParametricas->transaccion == true) {
            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_unidadmedida
                    (idunidadmedida   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idunidadmedida  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idunidadmedida',     $unidadMedidaID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarTipoHabitaciones($sucursal, $puntoventa, $empresa)
    {
        $tipoHabitacionID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarParametricaTipoHabitacion($sucursal, $puntoventa, $codigoCui['ccuis']);
        if ($res->RespuestaListaParametricas->transaccion == true) {
            $db = Config::getConnection();
            foreach ($res->RespuestaListaParametricas->listaCodigos as $listado) {
                $sql = "INSERT INTO impuestos_tipohabitacion
                    (idtipohabitacion   ,codigoclasificador, descripcion, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idtipohabitacion  ,:codigoclasificador, :descripcion,:transaccion,:estado,:id_empresa)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam('idtipohabitacion',     $tipoHabitacionID);
                $stmt->bindParam('codigoclasificador',     $listado->codigoClasificador);
                $stmt->bindParam('descripcion',     $listado->descripcion);
                $stmt->bindParam('transaccion',    $listado->transaccion);
                $stmt->bindParam('estado', $estado);
                $stmt->bindParam('id_empresa', $empresa);
                $stmt->execute();
            }
        }
        return $res;
    }

    public function sincronizarTotalActividades($sucursal, $puntoventa, $empresa)
    {
        
        $tipoActividadID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarActividades($sucursal, $puntoventa, $codigoCui['ccuis']);
        
        $tipoRespuesta = gettype($res);
        if ($tipoRespuesta === "string") {
            if ($res->RespuestaListaActividades->transaccion == true) {
                foreach ($res->RespuestaListaActividades->listaActividades as $listado) {
                    $db = Config::getConnection();
    
                    $sql = "INSERT INTO codigoactividades
                        (idcodigoactividad   ,codigocaeb, descripcion, tipoactividad ,transaccion,estado, id_empresa)
                        VALUES 
                        (:idcodigoactividad  ,:codigocaeb, :descripcion,:tipoactividad,:transaccion,:estado,:id_empresa)";
                    $stmt = $db->prepare($sql);
                    $stmt->bindParam('idcodigoactividad',     $tipoActividadID);
                    $stmt->bindParam('codigocaeb',      $listado->codigoCaeb);
                    $stmt->bindParam('descripcion',    $listado->descripcion);
                    $stmt->bindParam('tipoactividad',   $listado->tipoActividad);
                    $stmt->bindParam('transaccion', $res->RespuestaListaActividades->transaccion);
                    $stmt->bindParam('estado', $estado);
                    $stmt->bindParam('id_empresa', $empresa);
                    $stmt->execute();
                }
            }
            return $res;
            
        }else{
            if ($res->RespuestaListaActividades->transaccion == true) {
                
                    $db = Config::getConnection();
    
                    $sql = "INSERT INTO codigoactividades
                        (idcodigoactividad   ,codigocaeb, descripcion, tipoactividad ,transaccion,estado, id_empresa)
                        VALUES 
                        (:idcodigoactividad  ,:codigocaeb, :descripcion,:tipoactividad,:transaccion,:estado,:id_empresa)";
                    $stmt = $db->prepare($sql);
                    $stmt->bindParam('idcodigoactividad',     $tipoActividadID);
                    $stmt->bindParam('codigocaeb',      $res->RespuestaListaActividades->listaActividades->codigoCaeb);
                    $stmt->bindParam('descripcion',    $res->RespuestaListaActividades->listaActividades->descripcion);
                    $stmt->bindParam('tipoactividad',   $res->RespuestaListaActividades->listaActividades->tipoActividad);
                    $stmt->bindParam('transaccion', $res->RespuestaListaActividades->transaccion);
                    $stmt->bindParam('estado', $estado);
                    $stmt->bindParam('id_empresa', $empresa);
                    $stmt->execute();
                
            }
            return $res;
        }
    }

    public function sincronizarFechaHora($sucursal, $puntoventa, $empresa)
    {
        $fechaHoraID = null;
        $estado = 1;
        $codigoCui = $this->obtenerCuisDB($empresa);
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarFechaHora($sucursal, $puntoventa, $codigoCui['ccuis']);
        $arrayFecha["fechaHora"] = date("Y-m-d H:i:s", strtotime($res->RespuestaFechaHora->fechaHora . "+ 1 days"));
        if ($res->RespuestaFechaHora->transaccion == true) {
            $db = Config::getConnection();

            $sql = "INSERT INTO impuestos_fechayhora
                    (idfechayhora   ,fechahoraactual, fechahorafinal, transaccion ,estado, id_empresa)
                    VALUES 
                    (:idfechayhora  ,:fechahoraactual, :fechahorafinal,:transaccion,:estado,:id_empresa)";
            $stmt = $db->prepare($sql);
            $stmt->bindParam('idfechayhora',     $fechaHoraID);
            $stmt->bindParam('fechahoraactual',     $res->RespuestaFechaHora->fechaHora);
            $stmt->bindParam('fechahorafinal',     $arrayFecha["fechaHora"]);
            $stmt->bindParam('transaccion',    $res->RespuestaFechaHora->transaccion);
            $stmt->bindParam('estado', $estado);
            $stmt->bindParam('id_empresa', $empresa);
            $stmt->execute();
        }
        return $res;
    }

    public function obtenerFechaHora($sucursal, $puntoventa, $cuis)
    {
        $service     = new ServicioFacturacionSincronizacion();
        $service->setConfig((array)$this->configService->config);
        $res = $service->sincronizarFechaHora($sucursal, $puntoventa, $cuis);

        return $res;
    }

    public function getFechaFinal()
    {
        $db = Config::getConnection();
        $sql = "SELECT *
        FROM impuestos_fechayhora WHERE estado=1
        LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $getFecha = $stmt->fetch();
        return $getFecha;
    }
    public function sincronizarCatalogos($sucursal, $puntoventa, $empresa)
    {
        if ($this->getFechaFinal() > 0) {
            date_default_timezone_set('America/La_Paz');
            $fechaFinal = $this->getFechaFinal();
            if ($fechaFinal["fechahorafinal"] < date('Y-m-d H:i:s')) {
                $this->truncatesExec();
                $this->sincronizarListaLeyendasFactura($sucursal, $puntoventa, $empresa);
                $this->sincronizarMensajesServicios($sucursal, $puntoventa, $empresa);
                $this->sincronizarProductoServicios($sucursal, $puntoventa, $empresa);
                $this->sincronizarEventoSignificativos($sucursal, $puntoventa, $empresa);
                $this->sincronizarMotivosAnulaciones($sucursal, $puntoventa, $empresa);
                $this->sincronizarPaisesOrigen($sucursal, $puntoventa, $empresa);
                $this->sincronizarTipoDocumentoIdentidades($sucursal, $puntoventa, $empresa);
                $this->sincronizarTiposEmisiones($sucursal, $puntoventa, $empresa);
                $this->sincronizarMetodosPagos($sucursal, $puntoventa, $empresa);
                $this->sincronizarTiposPuntosFacturas($sucursal, $puntoventa, $empresa);
                $this->sincronizarUnidadesMedidas($sucursal, $puntoventa, $empresa);
                $this->sincronizarFechaHora($sucursal, $puntoventa, $empresa);
                $this->sincronizarTotalActividades($sucursal, $puntoventa, $empresa);
                $this->sincronizarTipoHabitaciones($sucursal, $puntoventa, $empresa);
                $this->sincronizarTiposMonedaas($sucursal, $puntoventa, $empresa);
                $this->sincronizarTiposPuntosVentas($sucursal, $puntoventa, $empresa);
                $this->sincronizarDocumentoSectores($sucursal, $puntoventa, $empresa);
                $this->sincronizarTipoDocumentoSectores($sucursal, $puntoventa, $empresa);
                return true;
            } else {
                $messageReturn["message"] = 'La base de datos se encuentra actualizada.';
                $messageReturn["status"] = false;
                return json_encode($messageReturn);
            }
        } else {
            $this->sincronizarListaLeyendasFactura($sucursal, $puntoventa, $empresa);
            $this->sincronizarMensajesServicios($sucursal, $puntoventa, $empresa);
            $this->sincronizarProductoServicios($sucursal, $puntoventa, $empresa);
            $this->sincronizarEventoSignificativos($sucursal, $puntoventa, $empresa);
            $this->sincronizarMotivosAnulaciones($sucursal, $puntoventa, $empresa);
            $this->sincronizarPaisesOrigen($sucursal, $puntoventa, $empresa);
            $this->sincronizarTipoDocumentoIdentidades($sucursal, $puntoventa, $empresa);
            $this->sincronizarTiposEmisiones($sucursal, $puntoventa, $empresa);
            $this->sincronizarMetodosPagos($sucursal, $puntoventa, $empresa);
            $this->sincronizarTiposPuntosFacturas($sucursal, $puntoventa, $empresa);
            $this->sincronizarUnidadesMedidas($sucursal, $puntoventa, $empresa);
            $this->sincronizarFechaHora($sucursal, $puntoventa, $empresa);
            $this->sincronizarTotalActividades($sucursal, $puntoventa, $empresa);
            $this->sincronizarTipoHabitaciones($sucursal, $puntoventa, $empresa);
            $this->sincronizarTiposMonedaas($sucursal, $puntoventa, $empresa);
            $this->sincronizarTiposPuntosVentas($sucursal, $puntoventa, $empresa);
            $this->sincronizarDocumentoSectores($sucursal, $puntoventa, $empresa);
            $this->sincronizarTipoDocumentoSectores($sucursal, $puntoventa, $empresa);
            return true;
        }
    }

    public function truncatesExec()
    {
        $db = Config::getConnection();
        $sql = "        
        TRUNCATE TABLE impuestos_unidadmedida;
        TRUNCATE TABLE codigoactividades;
        TRUNCATE TABLE impuestos_tipopuntodeventa;
        TRUNCATE TABLE impuestos_tipomoneda;
        TRUNCATE TABLE impuestos_tipometodopago;
        TRUNCATE TABLE impuestos_tipohabitacion;
        TRUNCATE TABLE impuestos_tipofactura;
        TRUNCATE TABLE impuestos_tipoemision;
        TRUNCATE TABLE impuestos_tipodocumentosector;
        TRUNCATE TABLE impuestos_productoservicios;
        TRUNCATE TABLE impuestos_paisorigen;
        TRUNCATE TABLE impuestos_motivoanulacion;
        TRUNCATE TABLE impuestos_mensajeservicio;
        TRUNCATE TABLE impuestos_leyendasfacturas;
        TRUNCATE TABLE impuestos_fechayhora;
        TRUNCATE TABLE impuestos_eventosignificativo;
        TRUNCATE TABLE impuestos_documentoidentidad;
        ";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        return true;
    }
}
