<?php

namespace App\ServiciosSiat;
// Add the desired namespace

require __DIR__ . '/ConfigService.php';

require __DIR__ . '/../API_REST/function/conexion_singleton.php';

require __DIR__ . '/SincronizarCatalogoService.php';

require __DIR__ . '/../Siat/Services/ServicioFacturacionCodigos.php';
require __DIR__ . '/../Siat/Services/ServicioOperaciones.php';

use Config;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioFacturacionCodigos;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioOperaciones;


class PuntoVentaService
{

    public $configService;
    public $catalogoService;

    public function __construct()
    {
        $this->configService = new ConfigService();
        $this->catalogoService = new SincronizarCatalogoService();
    }

    public function obtenerCuis($codigoPuntoVenta, $codigoSucursal, $new = false)
    {
        $serviceCodigos = new ServicioFacturacionCodigos(null, null, $this->configService->config->tokenDelegado);
        $serviceCodigos->debug = false;
        $serviceCodigos->setConfig((array)$this->configService->config);
        $resCuis = $serviceCodigos->cuis($codigoPuntoVenta, $codigoSucursal);

        return $resCuis;
    }

public function operacionesCuis($update, $responseCuis, $codigoSucursal, $codigoPuntoVenta, $nombre_pv, $empresa)
    {
        $db = Config::getConnection();
        $idPuntoVenta = null;
        $pcName =   gethostname();
        $pcMac = strtok(exec('getmac'), ' ');
        $estado = 1;

        if ($update) {
            $sql = "UPDATE puntodeventa                    
                    SET ccuis=:ccuis,fechavencimiento=:fechavencimiento,pc=:pc,mac=:mac,estado=:estado
                    WHERE csucursal=:csucursal AND cpuntoventa=:cpuntoventa AND id_empresa=:id_empresa";
        } else {
            $sql = "INSERT INTO puntodeventa
                    (id_puntoventa ,csucursal, cpuntoventa, ccuis,fechavencimiento,nombre_punto_venta ,pc, mac, estado,id_empresa)
            
                    VALUES 
                    (:id_puntoventa ,:csucursal, :cpuntoventa, :ccuis,:fechavencimiento,:nombre_punto_venta,:pc,:mac,:estado,:id_empresa)";
        }
        $stmt = $db->prepare($sql);

        if ($update) {
            $stmt->bindParam('ccuis',  $responseCuis->RespuestaCuis->codigo);
            $stmt->bindParam('fechavencimiento',   $responseCuis->RespuestaCuis->fechaVigencia);
            $stmt->bindParam('pc', $pcName);
            $stmt->bindParam('mac', $pcMac);
            $stmt->bindParam('estado',   $estado);
            $stmt->bindParam('csucursal',     $codigoSucursal);
            $stmt->bindParam('cpuntoventa',     $codigoPuntoVenta);
            $stmt->bindParam('id_empresa',   $empresa);
        } else {
            $stmt->bindParam('id_puntoventa',     $idPuntoVenta);
            $stmt->bindParam('csucursal',     $codigoSucursal);
            $stmt->bindParam('cpuntoventa',     $codigoPuntoVenta);
            $stmt->bindParam('ccuis',  $responseCuis->RespuestaCuis->codigo);
            $stmt->bindParam('fechavencimiento',   $responseCuis->RespuestaCuis->fechaVigencia);
            $stmt->bindParam('nombre_punto_venta',   $nombre_pv);

            $stmt->bindParam('pc', $pcName);
            $stmt->bindParam('mac', $pcMac);
            $stmt->bindParam('estado',   $estado);
            $stmt->bindParam('id_empresa',   $empresa);
        }
        $stmt->execute();
    }

    public function insertarCuis($codigoSucursal, $codigoPuntoVenta, $nombre_pv, $empresa, $update)
    {
        $responseCuis = $this->obtenerCuis($codigoPuntoVenta, $codigoSucursal, $new = false);
        if ($responseCuis->RespuestaCuis->transaccion === false) {
            if ( gettype($responseCuis->RespuestaCuis->mensajesList) === 'object' && $responseCuis->RespuestaCuis->mensajesList->codigo === 980) {
                $this->operacionesCuis($update, $responseCuis, $codigoSucursal, $codigoPuntoVenta, $nombre_pv, $empresa);
                return true;
            } else {
                return false;
            }
        } else {
            $this->operacionesCuis($update, $responseCuis, $codigoSucursal, $codigoPuntoVenta, $nombre_pv, $empresa);
            return true;
        }
    }

    function obtenerCufd($codigoPuntoVenta, $codigoSucursal, $cuis, $new = false)
    {

        $serviceCodigos = new ServicioFacturacionCodigos(null, null, $this->configService->config->tokenDelegado);
        $serviceCodigos->setConfig((array)$this->configService->config);

        $serviceCodigos->cuis = $cuis;
        $resCufd = $serviceCodigos->cufd($codigoPuntoVenta, $codigoSucursal);

        return $resCufd;
    }

    public function insertarCufd($codigoSucursal, $codigoPuntoVenta, $empresa)
    {
        $pc = gethostname();
        $mac = exec('getmac');
        $db = Config::getConnection();
        $sql = "SELECT ccuis
        FROM puntodeventa 
        WHERE pc=:pc AND mac=:mac AND id_empresa=:id_empresa AND estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':pc', $pc);
        $stmt->bindParam(':mac', $mac);
        $stmt->bindParam(':id_empresa', $empresa);
        $stmt->execute();
        $codigoCui = $stmt->fetch();
        $responseCufd = $this->obtenerCufd($codigoPuntoVenta, $codigoSucursal, $codigoCui['ccuis'], $new = false);
        $idCufd = null;
        $estado = 1;

        $sql = "INSERT INTO impuestos_cufd
                    (idcufd ,codigocufd, fechavigencia, transaccion, codigocontrol ,cuis, id_empresa, estado,direccion)
                    VALUES 
                    (:idcufd ,:codigocufd, :fechavigencia, :transaccion,:codigocontrol,:cuis,:id_empresa,:estado,:direccion)";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('idcufd',     $idCufd);
        $stmt->bindParam('codigocufd',     $responseCufd->RespuestaCufd->codigo);
        $stmt->bindParam('fechavigencia',     $responseCufd->RespuestaCufd->fechaVigencia);
        $stmt->bindParam('transaccion',  $responseCufd->RespuestaCufd->transaccion);
        $stmt->bindParam('codigocontrol',   $responseCufd->RespuestaCufd->codigoControl);
        $stmt->bindParam('cuis', $codigoCui['ccuis']);
        $stmt->bindParam('id_empresa', $empresa);
        $stmt->bindParam('estado',   $estado);
        $stmt->bindParam('direccion',   $responseCufd->RespuestaCufd->direccion);

        $stmt->execute();
        return $responseCufd;
    }

    public function registroPuntoVenta($sucursal, $tipoPuntoVenta, $nombre_pv, $desc_pv, $cuis)
    {
        $service = new ServicioOperaciones();
        $service->setConfig((array)$this->configService->config);
        $res = $service->registroPuntoVenta($sucursal, $tipoPuntoVenta, $nombre_pv, $desc_pv, $cuis);
        return $res;
    }

    public function getExistsPuntoVenta()
    {
        $pc = gethostname();
        $arrayMac['mac'] = exec('getmac');
        $db = Config::getConnection();
        $sql = "SELECT *
        FROM puntodeventa WHERE pc=:pc AND mac=:mac";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':pc', $pc);
        $stmt->bindParam(':mac', $arrayMac['mac']);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function getExistsPVEmpresa($sucursal, $empresaId, $tipoPuntoVenta)
    {
        //$pc = gethostname();
        //$arrayMac[ 'mac' ] = strtok( exec( 'getmac' ), ' ' );
        $db = Config::getConnection();
        $sql = "SELECT *
        FROM puntodeventa WHERE 
        csucursal=:csucursal AND id_empresa=:id_empresa AND cpuntoventa=:puntoventa";
        $arrayData['csucursal'] = $sucursal;
        $arrayData['empresaId'] = $empresaId;
        $arrayData['puntoventa'] = $tipoPuntoVenta;
        //echo json_encode( $arrayMac );

        $stmt = $db->prepare($sql);
        /* $stmt->bindParam( ':pc', $pc );
        $stmt->bindParam( ':mac', $arrayMac[ 'mac' ] );
        */
        $stmt->bindParam(':csucursal', $arrayData['csucursal']);
        $stmt->bindParam(':id_empresa', $arrayData['empresaId']);
        $stmt->bindParam(':puntoventa', $arrayData['puntoventa']);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            $arrayDatos = [
                'transaccion' => true,
                'data' => $stmt->fetch()
            ];
            return $arrayDatos;
        } else {
            $arrayDatos = [
                'transaccion' => false,
                'data' => null
            ];
            return $arrayDatos;
        }
    }

    public function getTipoPuntoVenta()
    {
        $db = Config::getConnection();
        $sql = "SELECT *
        FROM impuestos_tipopuntodeventa";
        $stmt = $db->prepare($sql);
        $stmt->execute();

        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(\PDO::FETCH_ASSOC)) {
                $array['content'][$i]['idtipopuntodeventa '] = trim($data['idtipopuntodeventa']);
                $array['content'][$i]['codigoclasificador']    = trim($data['codigoclasificador']);
                $array['content'][$i]['descripcion']           = trim($data['descripcion']);

                $i++;
            }
            return $array;
        }

        return false;



    }

    public function getExistsPVById($idPV)
    {
        $db = Config::getConnection();
        $sql = "SELECT *
        FROM puntodeventa WHERE 
        id_puntoventa =:idPV";
        $arrayData['idPV'] = $idPV;
        $stmt = $db->prepare($sql);
        //$stmt->bindParam( ':pc', $pc );
        //$stmt->bindParam( ':mac', $arrayMac[ 'mac' ] );
        $stmt->bindParam(':idPV', $arrayData['idPV']);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $arrayDatos = [
                'transaccion' => true,
                'data' => $stmt->fetch()
            ];
            return $arrayDatos;
        } else {
            return false;
        }
    }
}

$puntoVentaService = new PuntoVentaService();
$catalogoService = new SincronizarCatalogoService();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($_POST['metodo'] === 'registroPuntoVenta') {
        $sucursal = $_POST['sucursal'];
        $empresa  = $_POST['empresa'];
        $nombre_pv = $_POST['nombre_pv'];
        $desc_pv = $_POST['descripcion_pv'];
        $tipoPuntoVenta  = empty((int)$_POST['tipo_venta']) ? 0 : (int)$_POST['tipo_venta'];

        $res = $puntoVentaService->getExistsPVEmpresa($sucursal, $empresa, 0);

        if ($res['transaccion']) {

            $resPuntoVenta = $puntoVentaService->registroPuntoVenta($sucursal, $tipoPuntoVenta, $nombre_pv, $desc_pv, $res['data']['ccuis']);

            if ($resPuntoVenta->RespuestaRegistroPuntoVenta->transaccion) {
                $resCuisService = $puntoVentaService->insertarCuis($sucursal, $resPuntoVenta->RespuestaRegistroPuntoVenta->codigoPuntoVenta, $nombre_pv, $empresa, false);

                if ($resCuisService) {
                    echo json_encode(['transaccion' => true,'msg' => 'Punto de venta registrado']);
                } else {
                    echo json_encode(['transaccion' => true,'msg' => 'Punto de venta NO registrado']);
                }
            }
        } else {
            $resCuisService =  $puntoVentaService->insertarCuis($sucursal, $tipoPuntoVenta, $nombre_pv, $empresa, false);

            if ($resCuisService) {
                echo json_encode(['transaccion' => true,'msg' => 'Punto de venta registrado']);
            } else {
                echo json_encode(['transaccion' => true,'msg' => 'Punto de venta NO registrado']);
            }

            $catalogoService->sincronizarCatalogos($sucursal, $tipoPuntoVenta, $empresa);
            //echo json_encode(['transaccion' => true,'msg' => 'Punto de venta else registrado']);
        }
    } else if ($_POST['metodo'] === 'updatePV') {
        $res = $puntoVentaService->getExistsPVById((int)$_POST['id_punto_venta']);
        $puntoVentaService->insertarCuis($res['data']['csucursal'], $res['data']['cpuntoventa'], $res['nombre_punto_venta'] ,$res['data']['id_empresa'], true);
        echo json_encode(['transaccion' => true,'msg' => 'Punto de venta actualizado']);
    }

    //que no exista punto de venta
} else {
    $res = $puntoVentaService->getTipoPuntoVenta();
    //NO TOCAR LO DE ABAJO ES PARA LISTAR EN EL SELECT LOS TIPOS DE PUNTO DE VENTA RECORDATORIO
    echo json_encode($res);
}
