<?php

namespace App\ServiciosSiat;

if (!class_exists('SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioSiat')) {
    require_once __DIR__ . '/../Siat/Services/ServicioSiat.php';
}
require __DIR__ . '/ConfigService.php';
require __DIR__ . '/SincronizarCatalogoService.php';
require __DIR__ . '/../Siat/SiatFactory.php';
require __DIR__ . '/../Siat/Invoices/CompraVenta.php';
require __DIR__ . '/../Siat/Invoices/ElectronicaCompraVenta.php';
require __DIR__ . '/../Siat/Invoices/InvoiceDetail.php';
require __DIR__ . '/VerificarNitService.php';
require __DIR__ . '/../Siat/Services/ServicioFacturacionElectronica.php';


use Config;
use DateTime;
use PDO;
use VerificarNitService;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\DocumentTypes;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\SiatFactory;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Invoices\CompraVenta;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioSiat;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Invoices\ElectronicaCompraVenta;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Invoices\SiatInvoice;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Invoices\InvoiceDetail;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioFacturacionElectronica;

class EmisionIndividualService
{
    public $configService;
    public $verificarNitService;

    public function __construct()
    {
        $this->configService = new ConfigService();
        $this->verificarNitService = new VerificarNitService();
    }


    public function obtenerCLiente($dataFactura)
    {
        $data = (object) $dataFactura;

        $id_cliente = intval($data->id_cliente);
        $db = Config::getConnection();
        $sql = "SELECT *
         FROM cli_cliente
         WHERE id=:id 
         LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id', $id_cliente);
        $stmt->execute();
        $cliente = $stmt->fetch();
        return json_encode($cliente);
    }

    public function obtenerSucursal($dataFactura)
    {
        $data = (object)($dataFactura);
        $id_sucursal = intval($data->id_sucursal);

        $db = Config::getConnection();
        $sql = "SELECT *
        FROM em_sucursal
        WHERE id=:id 
        LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id', $id_sucursal);
        $stmt->execute();
        $sucursal = $stmt->fetch();
        return $sucursal;
    }



    public function obtenerCuis()
    {
        if (!isset($_SESSION)) {
            session_start();
        }
        $userData = json_decode($_SESSION['dataUser']);
        $userID = $userData->id;
        $empresaUser = $userData->id_empresa;
        $estado = 1;
        $db = Config::getConnection();
        $query = "SELECT * from puntodeventa p 
          join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
          where pvu.user_id = :user_id
          and p.id_empresa = :id_empresa
          and p.estado = :estado LIMIT 1; ";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':user_id', $userID);
        $stmt->bindParam(':id_empresa', $empresaUser);
        $stmt->bindParam(':estado', $estado);
        $stmt->execute();
        $cuis = $stmt->fetch();
        return $cuis;
    }

    public function obtenerCufd() //TODO añadir validacion segun usuario y pv
    {
        if (!isset($_SESSION)) {
            session_start();
        }
        $resCuis = $this->obtenerCuis();
        $userData = json_decode($_SESSION['dataUser']);
        $empresaUser = $userData->id_empresa;
        $db = Config::getConnection();
        $sql = "SELECT * 
        from impuestos_cufd ic 
        where ic.id_empresa =:empresa_id and ic.cuis =:cuis";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':empresa_id', $empresaUser);
        $stmt->bindParam(':cuis', $resCuis['ccuis']);
        $stmt->execute();
        $cufd = $stmt->fetch();
        return $cufd;
    }

    public function obtenerProducto($det)
    {
        $producto_id = $det["id_producto"];
        $db = Config::getConnection();
        $sql = "SELECT * FROM `pro_producto` WHERE  id=:id LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id', $producto_id);
        $stmt->execute();
        $producto = $stmt->fetch(\PDO::FETCH_ASSOC);
        return json_encode($producto);
    }

    public function obtenerUsuario($dataFactura)
    {
        $data = (object)($dataFactura);
        $usuario_id = $data->id_usuario;
        $db = Config::getConnection();
        $sql = "SELECT * from per_usuarios WHERE  id=:id LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id', $usuario_id);
        $stmt->execute();
        $usuario = $stmt->fetch();
        return json_encode($usuario);
    }

    public function getLeyenda($codigoActividad)
    {

        $db = Config::getConnection();
        $sql = "SELECT * FROM impuestos_leyendasfacturas il WHERE il.codigoclasificador = :codigoActividad ORDER BY RAND() LIMIT 1;";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('codigoActividad', $codigoActividad);
        $stmt->execute();
        $leyenda = $stmt->fetch();
        return $leyenda;
    }

    public function obtenerVentaByNroFactura($nroFactura)
    {
        $db = Config::getConnection();
        $sql = "SELECT * from venta WHERE nro_factura=:nro_factura LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':nro_factura', $nroFactura);
        $stmt->execute();
        $usuario = $stmt->fetch();
        return $usuario;
    }

    public function getExistsEventSin() //?Para el Evento 2
    {
        $data = $this->obtenerCuis();

        $db = Config::getConnection();

        $sql = "SELECT * FROM evento_significativos
         WHERE CodigoSucursal=:CodigoSucursal AND CodigoPVenta=:CodigoPVenta";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('CodigoSucursal', $data['csucursal']);
        $stmt->bindParam('CodigoPVenta', $data['cpuntoventa']);
        $stmt->execute();

        if ($stmt->execute()) {
            return [
                'existe' => true,
                'evento' => $stmt->fetch(PDO::FETCH_ASSOC),
            ];
        }
        return [
            'existe' => false,
            'evento' => null,
        ];
    }


    public function enviarFactura($dataFactura, $codigoEvento)
    {
        try {

            $codigoPuntoVenta = $this->configService->puntoventa;
            $codigoSucursal = $this->configService->sucursal;
            $clienteData = $this->obtenerCLiente($dataFactura);
            $usuarioData = $this->obtenerUsuario($dataFactura);
            $modalidad = $this->configService->config->modalidad;
            $documentoSector = $this->configService->documentoSector;
            $codigoActividad = $this->configService->codigoActividad;
            $codigoProductoSin = $this->configService->codigoProductoSin;
            $tipoFactura = $this->configService->tipoFactura;
            $cuis = $this->configService->config->cuis;

            $factura = $this->construirFactura($codigoPuntoVenta, $codigoSucursal, $modalidad, $documentoSector, $codigoActividad, $codigoProductoSin, $dataFactura, $clienteData, $usuarioData, $codigoEvento);

            /* $res = $this->testFactura($codigoSucursal, $codigoPuntoVenta, $factura, $tipoFactura, $codigoEvento); */
            $res = $this->testFirma($codigoSucursal, $codigoPuntoVenta, $factura, $tipoFactura, $codigoEvento);

            return [
                'res' => $res,
                'factura' => $factura,
            ];
        } catch (\Throwable $th) {
            throw $th;
        }
    }


    function construirFactura($codigoPuntoVenta = 0, $codigoSucursal = 0, $modalidad = 0, $documentoSector = 1, $codigoActividad, $codigoProductoSin, $dataFactura = null, $clienteData, $usuarioData, $codigoEvento)
    {
        $facturaData = (object)($dataFactura);
        $detalleFactura = $facturaData->productos;
        $cliente = json_decode($clienteData);
        $usuario = json_decode($usuarioData);
        $obtenerCuis = $this->obtenerCuis();
        $obtenerCufd = $this->obtenerCufd();
        $obtenerFechaHora = (new SincronizarCatalogoService())->obtenerFechaHora($codigoSucursal, $codigoSucursal, $obtenerCuis['ccuis']);
        $verificarNit = $this->verificarNitService->verificarNit($obtenerCuis['ccuis'], $codigoSucursal, $cliente->nit);
        $codigoVerificarNit =  $verificarNit->RespuestaVerificarNit->mensajesList->codigo;
        $fechaVenta = date('Y-m-d\TH:i:s.v');

        if ($codigoEvento == 2 || $codigoEvento == 5 || $codigoEvento == 6 || $codigoEvento == 7) {
            $eventoSignificativo = $this->getExistsEventSin();
            $fechaVenta = (new DateTime($facturaData->fecha_venta))->format('Y-m-d H:i:s.u');

            if ($fechaVenta <= $eventoSignificativo['evento']['FechaInicio']  &&   $fechaVenta >= $eventoSignificativo['evento']['FechaFinal']) {
                $mensaje = 'Fecha Venta no corresponde a la Fecha del Evento';
                return $mensaje;
            }
        }



        $factura = null;
        $detailClass = InvoiceDetail::class;

        if ($modalidad == ServicioSiat::MOD_ELECTRONICA_ENLINEA) {
            if ($documentoSector == DocumentTypes::FACTURA_COMPRA_VENTA)
                $factura = new ElectronicaCompraVenta();
        } else {
            if ($documentoSector == DocumentTypes::FACTURA_COMPRA_VENTA)
                $factura = new CompraVenta();
        }


        foreach ($detalleFactura as $det) {
            $resProducto = json_decode($this->obtenerProducto($det));
            $codigoActividad = $resProducto->id_homologacion;
            //echo json_encode($codigoActividad);

            $getLeyenda = $this->getLeyenda($codigoActividad);

            if ($getLeyenda == false) {
                $leyendaFactura = "Ley N�� 453: Puedes acceder a la reclamaci���n cuando tus derechos han sido vulnerados.";
            } else {
                $leyendaFactura = $getLeyenda['descripcion'];
            }
            $subTotal = 0;

            $det = (object)$det;
            $detalle = new $detailClass();
            $detalle->actividadEconomica    = $resProducto->id_homologacion; //CODIGO ACTIVIDAD
            $detalle->codigoProductoSin        = $resProducto->codigo_actividad; //CODIGO PRODUCTO
            $detalle->codigoProducto        = $det->id_producto;
            $detalle->descripcion            = $det->nombre;
            $detalle->cantidad                =  $det->cantidad;
            $detalle->unidadMedida          = $resProducto->id_unidad_medida;
            $detalle->precioUnitario        = $det->precio;
            $detalle->montoDescuento        = (empty($det->desc) ? 0 : $det->desc) * $det->cantidad;
            $detalle->subTotal                = number_format((float)$det->costo, 2, '.', '');
            $subTotal += $detalle->subTotal;
            $factura->detalle[] = $detalle;
        }
        $factura->cabecera->razonSocialEmisor    = $this->configService->config->razonSocial;
        $factura->cabecera->municipio            = $this->configService->config->ciudad;
        $factura->cabecera->telefono            = $this->configService->config->telefono;
        $factura->cabecera->numeroFactura        = intval($facturaData->nro_factura);
        $factura->cabecera->codigoSucursal        = $codigoSucursal;
        $factura->cabecera->direccion            = $obtenerCufd['direccion'];
        $factura->cabecera->codigoPuntoVenta    = $codigoPuntoVenta;
        $factura->cabecera->fechaEmision        =  $fechaVenta; // $obtenerFechaHora->fechaHora;
        $factura->cabecera->codigoTipoDocumentoIdentidad    = $cliente->tipo_documento_id;
        $factura->cabecera->codigoMetodoPago    = $facturaData->tipo_pago;
        $factura->cabecera->numeroTarjeta       = $facturaData->tarjeta;

        if ($cliente->tipo_documento_id == 1 || $cliente->tipo_documento_id == 2 || $cliente->tipo_documento_id == 3 || $cliente->tipo_documento_id == 4) {
            $codigoExcepcionNit = 0;
        } else {
            $codigoExcepcionNit = $codigoVerificarNit == 986 ? 0 : 1;
        }
        $factura->cabecera->codigoCliente        = $cliente->id;
        $factura->cabecera->nombreRazonSocial    = htmlspecialchars($cliente->nombre);
        $factura->cabecera->numeroDocumento        = $cliente->nit; /* Documento del Cliente CI||NIT etc $cliente->nit */
        $factura->cabecera->complemento        = isset($cliente->complemento) ? $cliente->complemento : '';
        $factura->cabecera->montoTotal            = $facturaData->total - $facturaData->descuento;
        $factura->cabecera->montoTotalMoneda    = $facturaData->total - $facturaData->descuento;
        $factura->cabecera->montoTotalSujetoIva    = $facturaData->total - ($facturaData->descuento + $facturaData->monto_giftcard);
        $factura->cabecera->montoGiftCard = $facturaData->monto_giftcard;
        $factura->cabecera->codigoMoneda        = $facturaData->tipo_moneda; //Frontend
        $factura->cabecera->descuentoAdicional    = $facturaData->descuento;
        $factura->cabecera->tipoCambio            =  $facturaData->tipo_moneda; //Frontend
        $factura->cabecera->leyenda            =  $leyendaFactura;
        $factura->cabecera->usuario                = $usuario->nombre;
        $factura->cabecera->codigoExcepcion           = $codigoExcepcionNit;

        return $factura;
    }
   /*  function testFactura($sucursal, $puntoventa, SiatInvoice $factura, $tipoFactura, $codigoEvento)
    {
        $cuis = $this->obtenerCuis();
        $cufd = $this->obtenerCufd();
        
        $service = SiatFactory::obtenerServicioFacturacion($this->configService->config, $cuis['ccuis'], $cufd['codigocufd'], $cufd['codigocontrol']);
        $service->codigoControl = $cufd['codigocontrol'];
        $res = $service->recepcionFactura($factura, SiatInvoice::TIPO_EMISION_ONLINE, $tipoFactura, $codigoEvento);
        return  $res;
    } */
    
    function testFirma($sucursal, $codigoPuntoVenta, SiatInvoice $factura, $tipoFactura, $codigoEvento)
	{
		
        $cuis = $this->obtenerCuis();
		$cufd = $this->obtenerCufd();

		$service = new ServicioFacturacionElectronica($cuis['ccuis'], $cufd['codigocufd'], $this->configService->config->tokenDelegado);
		$service->setConfig((array)$this->configService->config);
		$service->codigoControl = $cufd['codigocontrol'];
		$service->setPrivateCertificateFile($this->configService->config->privCert);
		$service->setPublicCertificateFile($this->configService->config->pubCert);
        
		$service->debug = !true;

		$tipoEmision = SiatInvoice::TIPO_EMISION_ONLINE;
		$res = $service->recepcionFactura($factura, $tipoEmision, $tipoFactura,$codigoEvento);
		
		return $res;
	}
}
