<?php

namespace App\ServiciosSiat; // Add the desired namespace

require_once __DIR__ . '/../Siat/SiatConfig.php';

require_once __DIR__ . '/../Siat/DocumentTypes.php';

if (!class_exists('SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioSiat')) {
  require_once __DIR__ . '/../Siat/Services/ServicioSiat.php';
}
require_once __DIR__ . '/../Siat/Invoices/SiatInvoice.php';
require_once __DIR__ . '/../Siat/constants.php';

use Config;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\SiatConfig;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\DocumentTypes;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Invoices\SiatInvoice;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioSiat;

class ConfigService
{

  public $config;
  public $sucursal             = 0;
  public $puntoventa           = 0;
  public $cantFacturas        = 1000;
  public $codigoEvento        = 0;
  public $evento             = null;
  public $codigoActividad    = '465000';
  public $codigoProductoSin    = '99100';
  public $documentoSector    = DocumentTypes::FACTURA_COMPRA_VENTA;
  public $tipoFactura        = SiatInvoice::FACTURA_DERECHO_CREDITO_FISCAL;
  public $modalidad           = 1;
  public $cafc                 = "1011917833B0D";
  public $resEvento             = null;

  public function __construct()
  {
    $userLog = $this->getTaxesInfoUser();
    $puntoVentaDB =  $this->getPointSale($userLog[1]['id']);
    if ($puntoVentaDB != false) {
      $this->puntoventa = isset(($puntoVentaDB[0]['cpuntoventa'])) ? (int)($puntoVentaDB[0]['cpuntoventa']) : $this->puntoventa;
      $this->sucursal = isset(($puntoVentaDB[0]['csucursal'])) ? (int)($puntoVentaDB[0]['csucursal']) : $this->sucursal;
    }
    $this->config = new SiatConfig([
      'nombreSistema' => 'JOBS',
      'codigoSistema' => $userLog[0]['codigoSistema'],
      'nit'           => $userLog[1]['nit'],
      'cuis'          => isset($puntoVentaDB[0]['ccuis']) ? $puntoVentaDB[0]['ccuis'] : null,
      'razonSocial'   => $userLog[1]['nombre'],
      'modalidad'     => $userLog[0]['modalidad'],
      'ambiente'      => $userLog[0]['ambiente'],
      'tokenDelegado' => $userLog[0]['token'],
      'pubCert'		    => MOD_SIAT_DIR . SB_DS . 'certs' . SB_DS . 'terminalx' . SB_DS . $userLog[0]['certificado_publico'],
	    'privCert'		  => MOD_SIAT_DIR . SB_DS . 'certs' . SB_DS . 'terminalx' . SB_DS . $userLog[0]['certificado_privado'], //? EL QUE DICE LLAVE ES EL PRIVADO xd 
      'telefono'      => $userLog[1]['telefono'],
      'ciudad'        => 'Santa Cruz'

    ]);
  }


  public function getTaxesInfoUser()
  {    
    if (session_status() === PHP_SESSION_NONE) {
      session_start();
    }

    $userEmpresaID = json_decode($_SESSION['dataUser']);
    $db = Config::getConnection();
    $query = "SELECT * FROM parametro_sin ps
      WHERE ps.id_empresa =:id_empresa 
      ORDER BY ps.id_empresa DESC
      LIMIT 1";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':id_empresa', $userEmpresaID->id_empresa);
    $stmt->execute();
    if ($stmt->rowCount() > 0) {
      $userLog = $stmt->fetch(\PDO::FETCH_ASSOC); // Obtener la fila como array asociativo
      $enterpriseUser = $this->getEnterPrise($userLog['id_empresa']);
      return [
        $userLog,
        $enterpriseUser
      ];
    } else {
      return [];
    }
  }

  function getEnterPrise($empresaID)
  {
    $query = "SELECT * 
    from em_empresa ee 
    where ee.id =:empresaID  
    LIMIT 1 ";
    $db = Config::getConnection();
    $stmt = $db->prepare($query);
    $stmt->bindParam(':empresaID', $empresaID);
    $stmt->execute();
    if ($stmt->rowCount() > 0) {
      $empresa = $stmt->fetch(\PDO::FETCH_ASSOC);
      return $empresa;
    }
  }

  function getPointSale($empresaID)
  {
    try {      
      if (session_status() === PHP_SESSION_NONE) {
        session_start();
      }
      $userData = json_decode($_SESSION['dataUser']);
      $userID = $userData->id;
      $estado = 1;
      $query = "SELECT * from puntodeventa p 
      join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
      where pvu.user_id = :user_id
      and p.id_empresa = :id_empresa
      and p.estado = :estado LIMIT 1; ";
      /*  $query = "SELECT * 
      from puntodeventa p 
      where p.id_empresa =:empresaID AND p.pc=:pc AND p.mac=:mac
      LIMIT 1"; */
      $db = Config::getConnection();
      $stmt = $db->prepare($query);


      /* $arrayData["pc"] = gethostname();
      $arrayData["mac"] = strtok(exec('getmac'), ' '); */
      $stmt->bindParam(':id_empresa', $empresaID);
      $stmt->bindParam(':user_id', $userID);
      $stmt->bindParam(':estado', $estado);
      $stmt->execute();
      if ($stmt->rowCount() > 0) {
        $puntoVenta = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        return $puntoVenta;
      } else {
        return false; /* False si aun no existe un PV0 */
      }
    } catch (\Throwable $th) {
      echo $th;
    }
  }
}
