<?php

namespace App\ServiciosSiat; // Add the desired namespace

require __DIR__ . '/../API_REST/function/conexion_singleton.php';

require __DIR__ . '/../Siat/Services/ServicioFacturacionComputarizada.php';

require __DIR__ . '/../Siat/Services/ServicioFacturacionElectronica.php';

require __DIR__ . '/ConfigService.php';

require __DIR__ . '/../API_REST/PHPmailer/PHPMailerAutoload.php';

require __DIR__ . '/../API_REST/PHPmailer/PHPMailer.php';


require __DIR__ . '/../API_REST/dompdf/vendor/dompdf/dompdf/src/Options.php';

require __DIR__ . '/../API_REST/dompdf/vendor/dompdf/dompdf/src/Dompdf.php';

require __DIR__ . '/../API_REST/dompdf/vendor/dompdf/dompdf/src/FontMetrics.php';

require __DIR__ . '/../API_REST/function/builfFacturaMiddlePage.php';

require_once __DIR__ . '/../API_REST/dompdf/vendor/autoload.php';

require_once __DIR__ . '/../Siat/Services/ServicioVerificarFactura.php';

use Config;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\DocumentTypes;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioFacturacionComputarizada;


use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioVerificarFactura;
use Dompdf\Dompdf;
use Dompdf\FontMetrics;
use Dompdf\Options;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioFacturacionElectronica;

class  AnularFacturaService
{

    public $configService;

    public function __construct()
    {
        $this->configService = new ConfigService();
    }

    public function obtenerCuis($sucursal, $puntoventa)
    {
        if (!isset($_SESSION)) {
            session_start();
        }
        $userData = json_decode($_SESSION['dataUser']);
        $empresaUser = $userData->id_empresa;
        $estado = 1;

        $db = Config::getConnection();

        $sql = "SELECT * from puntodeventa          
          where csucursal=:sucursal and cpuntoventa=:puntoventa
          and id_empresa=:empresa
          and estado =:estado LIMIT 1;";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':sucursal', $sucursal);
        $stmt->bindParam(':puntoventa', $puntoventa);
        $stmt->bindParam(':empresa', $empresaUser);
        $stmt->bindParam(':estado', $estado);
        $stmt->execute();
        $cuis = $stmt->fetch();
        return $cuis;
    }

    public function obtenerCufd()
    {
        $db = Config::getConnection();
        $sql = "SELECT *
        FROM impuestos_cufd
        ORDER BY idcufd DESC
        LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $cufd = $stmt->fetch();
        return $cufd;
    }

    public function obtenerFactura($factura_id)
    {
        $db = Config::getConnection();
        $sql = "SELECT v.*
         FROM venta as v
         WHERE v.id=:id";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id', $factura_id);
        $stmt->execute();
        $factura = $stmt->fetch();
        return $factura;
    }

    public function obtenerVentaId($venta_id)
    {
        $db = Config::getConnection();
        $sql = "SELECT v.*
         FROM venta as v
         WHERE v.id=:nro_factura";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':nro_factura', $venta_id);
        $stmt->execute();
        $factura = $stmt->fetch();
        return $factura;
    }

    public function obtenerDetVentaId($venta_id)
    {
        $db = Config::getConnection();
        $sql = "SELECT v.*
         FROM det_venta as v
         WHERE v.id_venta=:venta_id";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':venta_id', $venta_id);
        $stmt->execute();
        $factura = $stmt->fetchAll();
        return $factura;
    }

    public function obtenerInventarioData($id_producto, $id_almacen)
    {
        $db = Config::getConnection();
        $sql = "SELECT SUM(cantidad) as cantidad, id_det_ingreso
         FROM in_inventario
         WHERE id_producto=:id_producto AND id_almacen=:id_almacen ORDER BY id DESC LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_producto', $id_producto);
        $stmt->bindParam(':id_almacen', $id_almacen);
        $stmt->execute();
        $factura = $stmt->fetch(\PDO::FETCH_ASSOC);
        return $factura;
    }

    public function updateInventario($id_det_ingreso, $id_producto, $id_almacen, $cantidad)
    {
         $db = Config::getConnection();

        $sql = "INSERT INTO in_inventario (cantidad, id_det_ingreso, id_producto, id_almacen, fecha_reg, fecha_up, estado) VALUES (:cantidad, :id_det_ingreso, :id_producto, :id_almacen, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 1)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':cantidad', $cantidad);
        $stmt->bindParam(':id_det_ingreso', $id_det_ingreso);
        $stmt->bindParam(':id_producto', $id_producto);
        $stmt->bindParam(':id_almacen', $id_almacen);
        
        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function updateFactura($factura_id)
    {
        $db = Config::getConnection();
        $estadoAnulado = 1; //1 es anulado
        $venta = "UPDATE venta set estado_anulacion=:estado_anulacion WHERE id =:id";
        $stmt = $db->prepare($venta);
        $stmt->bindParam('estado_anulacion',     $estadoAnulado);
        $stmt->bindParam('id',   $factura_id);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    }

    function getSucursal($sucursalID)
    {
        $db = Config::getConnection();

        $query = "SELECT * from em_sucursal es where es.id =:sucursalID ";
        $stmt = $db->prepare($query);
        $stmt->bindParam('sucursalID',     $sucursalID);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            return  $stmt->fetch();
        } else {
            return false;
        }
    }

    public function anularFactura($factura_id, $motivo_anulacion)
    {
        $factura = $this->obtenerFactura($factura_id);
        $detVenta = $this->obtenerDetVentaId($factura["id"]);

        $cuf = $factura['cuf'];
        $data_factura = json_decode($factura['data_factura']);
        $sucursal = $this->getSucursal($factura['id_sucursal']);
        //echo json_encode(gettype($data_factura->cabecera->codigoSucursal));
        $resCuis =  $this->obtenerCuis($factura['punto_venta_id'], $sucursal['codigosucursal']);
        $sucursal = $sucursal['codigosucursal'];
        $codigoPuntoVenta = $factura['punto_venta_id'];
        $tipoFactura = $this->configService->tipoFactura;
        $tipoEmision = 1; //1 ONLINE 2 OFFLINE 3 MASIVA
        $documentoSector = DocumentTypes::FACTURA_COMPRA_VENTA;
        $response = $this->testAnular($motivo_anulacion, $cuf, $sucursal, $codigoPuntoVenta, $tipoFactura, $tipoEmision, $documentoSector);
        if ($response->RespuestaServicioFacturacion->codigoEstado === 905) {
            $res = $this->updateFactura($factura['id']);

            foreach ($detVenta as $det) {
                $getInv = $this->obtenerInventarioData($det["id_producto"], $det["id_almacen"]);
                $this->updateInventario($getInv["id_det_ingreso"], $det["id_producto"], $det["id_almacen"], $det['cantidad']);
            }

            $this->sendMailtoCustomer(json_decode($factura["data_factura"]), $factura);
            if ($res) {
                return $response;
            }
        } else {
            return $response;
        }
    }

    function testAnular($motivo, $cuf, $sucursal, $puntoventa, $tipoFactura, $tipoEmision, $documentoSector)
    {

        $resCuis =  $this->obtenerCuis($sucursal, $puntoventa);
        $resCufd = $this->obtenerCufd();

        $service = new ServicioFacturacionComputarizada();
        $service->setConfig((array)$this->configService->config);
        $service->cuis = $resCuis['ccuis'];
        $service->cufd = $resCufd['codigocufd'];

        $res = $service->anulacionFactura($motivo, $cuf, $sucursal, $puntoventa, $tipoFactura, $tipoEmision, $documentoSector);

        return $res;
    }

    

    function getClient($idCliente)
    {
        $db = Config::getConnection();
        $query = "SELECT * FROM  cli_cliente c WHERE c.id=:idCliente;";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':idCliente', $idCliente);
        $stmt->execute();
        $cliente = $stmt->fetch();

        return json_encode($cliente);
    }

    function getEstadoAnulacionNroFactura($nro_factura, $cuf)
    {
        $db = Config::getConnection();
        $sql = "SELECT evento_significativo_id,estado_anulacion FROM venta WHERE  nro_factura=:nro_factura AND cuf=:cuf LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':nro_factura', $nro_factura);
        $stmt->bindParam(':cuf', $cuf);
        $stmt->execute();
        $response = $stmt->fetch(\PDO::FETCH_ASSOC);

        return json_encode($response);
    }

    function getEstadoAnulacionIdFactura($id_factura)
    {
        $db = Config::getConnection();
        $sql = "SELECT evento_significativo_id,estado_anulacion, nro_factura FROM venta WHERE  id=:id_factura LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_factura', $id_factura);
        $stmt->execute();

        $response = $stmt->fetch(\PDO::FETCH_ASSOC);

        return json_encode($response);
    }

    function getCorreosVar()
    {
        if (!isset($_SESSION)) {
            session_start();
        }

        $userEmpresaID = json_decode($_SESSION['dataUser']);

        $db = Config::getConnection();
        $sql = "SELECT * FROM impuestos_correo WHERE  id_empresa =:id_empresa LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_empresa', $userEmpresaID->id_empresa);
        $stmt->execute();
        $response = $stmt->fetch(\PDO::FETCH_ASSOC);

        return $response;
    }

    function sendMailtoCustomer($dataFactura, $dataVenta)
    {
        // Instanciar el objeto PHPMailer
        $mail = new PHPMailer(true);
        $idCliente = isset($dataFactura->cabecera->codigoCliente)
            ? $dataFactura->cabecera->codigoCliente : $dataFactura->id_cliente;
        $resCodigoCliente = json_decode($this->getClient($idCliente));

        try {
            // Configurar el servidor SMTP
            $mail->isSMTP();
            $mail->Host = $this->getCorreosVar()["host"];
            $mail->SMTPAuth = true;
            $mail->Username = $this->getCorreosVar()["correo"];
            $mail->Password = $this->getCorreosVar()["contrasena"];
            $mail->Port = $this->getCorreosVar()["puerto"];
            $mail->SMTPSecure = $this->getCorreosVar()["ssltls"] == 1 ? 'ssl' : 'tls';
            // Configurar el remitente y el destinatario
            $mail->setFrom($this->getCorreosVar()["correo"]);
            $mail->addAddress($resCodigoCliente->correo);
            $mail->addCC('rdamain@rda-consultores.com', $resCodigoCliente->correo);
            // Configurar el contenido del correo
            $mail->isHTML(true);
            //Se ha realizado la anulacion de la Factura Nro.: 405 con Codigo de Autorizacion: BE41C7190D91FD2B58FE642583922AAAE13067B21223FBF1EA6EFD74
            $mail->Subject = 'Anulacion de Factura' ;
            $mail->Body = 'Se ha realizado la anulacion de la Factura Nro.: ' . $dataFactura->cabecera->numeroFactura . ' con Codigo de Autorizacion: ' . $dataFactura->cabecera->cuf . ' Motivo: ' . " " . "FACTURA MAL EMITIDA";

            $getDataAnulacion = json_decode($this->getEstadoAnulacionNroFactura($dataFactura->cabecera->numeroFactura, $dataFactura->cabecera->cuf));

            //if ($getDataAnulacion->estado_anulacion != 0) {
            //EMPIEZA EL ANULADO
            $options = new Options();
            $options->set('isPhpEnabled', true);
            $options->set('isJavascriptEnabled ', true);
            $options->set('isHtml5ParserEnabled  ', true);
            $options->set('isRemoteEnabled', true);
            $options->setIsRemoteEnabled(true);
            $options->setIsHtml5ParserEnabled(true);
            $options->setIsPhpEnabled(true);
            $options->setIsJavascriptEnabled(true);
            //}
            $dompdf = new Dompdf($options);
            $dompdf->loadHtml(buildFacturaMiddlePage($dataFactura, $dataVenta));
            /* $dompdf->loadHtml(buildFacturaVaucher($dataFactura, $dataVenta)); */
            /* $dompdf->setPaper([0, 0, 950.98, 280.05], 'landscape'); */
            $dompdf->setPaper('letter', 'landscape');
            $dompdf->render();
            if ($getDataAnulacion->estado_anulacion != 0) {
                // instantiate and use the dompdf class

                $canvas = $dompdf->get_canvas();

                $fontMetrics = new FontMetrics($canvas, $options);
                $w = $canvas->get_width();
                $h = $canvas->get_height();
                $font = $fontMetrics->getFont('times');
                $text = "ANULADO";

                $txtHeight = $fontMetrics->getFontHeight($font, 75);
                $textWidth = $fontMetrics->getTextWidth($text, $font, 75);

                $x = ($w - $textWidth) / 2;
                $y = ($h - $txtHeight) / 1.4;
                $canvas->text($x, $y, $text, $font, 75, array(255, 0, 0), '', '', -30);
                //FIND DE ANULADO
            }
            // (Optional) Setup the paper size and orientation        


            //file_put_contents(__DIR__ . '/../../FacturasPDF/factura-' . $dataFactura->cabecera->numeroDocumento . '-' . $dataFactura->cabecera->numeroFactura . '.pdf', $dompdf->output());
            $evento = $getDataAnulacion->evento_significativo_id == -1 ? 0 : $getDataAnulacion->evento_significativo_id;
            file_put_contents(__DIR__ . '/../FacturasPDF/factura-' . $dataFactura->cabecera->numeroFactura . '-' . $evento . '.pdf', $dompdf->output());
            $mail->addStringAttachment($dompdf->output(), 'factura.pdf');
            // Enviar el correo
            $mail->send();
        } catch (Exception $e) {
            throw $e;
            /* echo 'Hubo un error al enviar el correo: ' . $mail->ErrorInfo; */
        }
    }
    
    function sendMailtoCustomerReversion($dataFactura, $dataVenta)
    {
        // Instanciar el objeto PHPMailer
        $mail = new PHPMailer(true);
        $idCliente = isset($dataFactura->cabecera->codigoCliente)
            ? $dataFactura->cabecera->codigoCliente : $dataFactura->id_cliente;
        $resCodigoCliente = json_decode($this->getClient($idCliente));

        try {
            // Configurar el servidor SMTP
            $mail->isSMTP();
            $mail->Host = $this->getCorreosVar()["host"];
            $mail->SMTPAuth = true;
            $mail->Username = $this->getCorreosVar()["correo"];
            $mail->Password = $this->getCorreosVar()["contrasena"];
            $mail->Port = $this->getCorreosVar()["puerto"];
            $mail->SMTPSecure = $this->getCorreosVar()["ssltls"] == 1 ? 'ssl' : 'tls';
            // Configurar el remitente y el destinatario
            $mail->setFrom($this->getCorreosVar()["correo"]);
            $mail->addAddress($resCodigoCliente->correo);
            $mail->addCC('rdamain@rda-consultores.com', $resCodigoCliente->correo);
            // Configurar el contenido del correo
            $mail->isHTML(true);
            //Se ha realizado la anulacion de la Factura Nro.: 405 con Codigo de Autorizacion: BE41C7190D91FD2B58FE642583922AAAE13067B21223FBF1EA6EFD74
            $mail->Subject = 'Reversion de Anulacion' ;
            $mail->Body = 'Se ha realizado la reversion  de la Factura  Anulada Nro.: ' . $dataFactura->cabecera->numeroFactura . ' con Codigo de Autorizacion: ' . $dataFactura->cabecera->cuf;

            $getDataAnulacion = json_decode($this->getEstadoAnulacionNroFactura($dataFactura->cabecera->numeroFactura, $dataFactura->cabecera->cuf));

            //if ($getDataAnulacion->estado_anulacion != 0) {
            //EMPIEZA EL ANULADO
            $options = new Options();
            $options->set('isPhpEnabled', true);
            $options->set('isJavascriptEnabled ', true);
            $options->set('isHtml5ParserEnabled  ', true);
            $options->set('isRemoteEnabled', true);
            $options->setIsRemoteEnabled(true);
            $options->setIsHtml5ParserEnabled(true);
            $options->setIsPhpEnabled(true);
            $options->setIsJavascriptEnabled(true);
            //}
            $dompdf = new Dompdf($options);
            $dompdf->loadHtml(buildFacturaMiddlePage($dataFactura, $dataVenta));
            /* $dompdf->loadHtml(buildFacturaVaucher($dataFactura, $dataVenta)); */
            /* $dompdf->setPaper([0, 0, 950.98, 280.05], 'landscape'); */
            $dompdf->setPaper('letter', 'landscape');
            $dompdf->render();
            if ($getDataAnulacion->estado_anulacion != 0) {
                // instantiate and use the dompdf class

                $canvas = $dompdf->get_canvas();

                $fontMetrics = new FontMetrics($canvas, $options);
                $w = $canvas->get_width();
                $h = $canvas->get_height();
                $font = $fontMetrics->getFont('times');
                $text = "ANULADO";

                $txtHeight = $fontMetrics->getFontHeight($font, 75);
                $textWidth = $fontMetrics->getTextWidth($text, $font, 75);

                $x = ($w - $textWidth) / 2;
                $y = ($h - $txtHeight) / 1.4;
                $canvas->text($x, $y, $text, $font, 75, array(255, 0, 0), '', '', -30);
                //FIND DE ANULADO
            }
            // (Optional) Setup the paper size and orientation        


            //file_put_contents(__DIR__ . '/../../FacturasPDF/factura-' . $dataFactura->cabecera->numeroDocumento . '-' . $dataFactura->cabecera->numeroFactura . '.pdf', $dompdf->output());
            $evento = $getDataAnulacion->evento_significativo_id == -1 ? 0 : $getDataAnulacion->evento_significativo_id;
            file_put_contents(__DIR__ . '/../FacturasPDF/factura-' . $dataFactura->cabecera->numeroFactura . '-' . $evento . '.pdf', $dompdf->output());
            $mail->addStringAttachment($dompdf->output(), 'factura.pdf');
            // Enviar el correo
            $mail->send();
        } catch (Exception $e) {
            throw $e;
            /* echo 'Hubo un error al enviar el correo: ' . $mail->ErrorInfo; */
        }
    }
    function verEstadoFactura($venta_id)
    {
        $factura = $this->obtenerVentaId($venta_id);
        $cuf = $factura['cuf'];
        $data_factura = json_decode($factura['data_factura']);

        if (isset($data_factura->cabecera->codigoPuntoVenta)) {
            $codigoPV = $data_factura->cabecera->codigoPuntoVenta;
            $codigoSucursal = $data_factura->cabecera->codigoSucursal;
        } else {
            $codigoPV = $data_factura->codigoPuntoVenta;
            $codigoSucursal = $this->getSucursal($data_factura->sucursal_id)["codigosucursal"];
        }

        $claseVerificar = new ServicioVerificarFactura();
        $verificarEstadoFactura = $claseVerificar->verificacionEstadoFactura(
            $cuf,
            $this->obtenerCuis($codigoSucursal, $codigoPV)["ccuis"],
            $this->obtenerCufd()["codigocufd"],
            $codigoPV,
            $codigoSucursal,
            1,
            $factura['evento_significativo_id']
        );
        return [
            "transaccion" => true,
            "msg" => $verificarEstadoFactura->RespuestaServicioFacturacion
        ];
    }

    public function updateFacturaReversion($factura_id)
    {
        $db = Config::getConnection();
        $estadoAnulado = 0; //Vuelve Activo
        $estadoReversion = 1; /* Se revirtio alguna vez */
        $venta = "UPDATE venta set estado_anulacion=:estado_anulacion , estado_reversion=:estado_reversion WHERE id=:id";
        $stmt = $db->prepare($venta);
        $stmt->bindParam('estado_anulacion',     $estadoAnulado);
        $stmt->bindParam('estado_reversion',     $estadoReversion);
        $stmt->bindParam('id',   $factura_id);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function revertirAnulacionFactura($facturaID){

        $factura = $this->obtenerFactura($facturaID);
        $cuf = $factura['cuf'];
        $sucursal = $this->getSucursal($factura['id_sucursal']);
        $sucursal = $sucursal['codigosucursal'];
        $codigoPuntoVenta = $factura['punto_venta_id'];
        $tipoFactura = $this->configService->tipoFactura;

        $modalidad = $this->configService->modalidad;

        $tipoEmision = 1; //1 ONLINE 2 OFFLINE 3 MASIVA
        $documentoSector = DocumentTypes::FACTURA_COMPRA_VENTA;
        $reversion = $this->revertirFacturaAnulada($cuf,$sucursal,$codigoPuntoVenta,$tipoFactura,$tipoEmision,$documentoSector);
        if ($reversion->RespuestaServicioFacturacion->codigoEstado === 907) {
            
            $res = $this->updateFacturaReversion($factura['id']); 
            $resEnvio = $this->envioMensajeReversion($factura["data_factura"]);
        }else{
            $mensajeExcepcion = $reversion->RespuestaServicioFacturacion->mensajesList->descripcion;
        }

        return $reversion;
    }
    
    function envioMensajeReversion($dataFactura){
        $envioPdfReversion = $this->sendMailtoCustomerReversion(json_decode($dataFactura ), $dataFactura);
    }

    function revertirFacturaAnulada($cuf, $sucursal, $puntoventa, $tipoFactura, $tipoEmision, $documentoSector)
    {

        $resCuis =  $this->obtenerCuis($sucursal, $puntoventa);
        $resCufd = $this->obtenerCufd();

        /* $service = new ServicioFacturacionComputarizada(); */
        $service = new ServicioFacturacionElectronica();
        $service->setConfig((array)$this->configService->config);
        $service->cuis = $resCuis['ccuis'];
        $service->cufd = $resCufd['codigocufd'];

        $res = $service->reversionAnulacionFactura ($cuf, $sucursal, $puntoventa, $tipoFactura, $tipoEmision, $documentoSector);

        return $res;
    }
}

$anulacionFacturaService = new AnularFacturaService();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($_POST['metodo'] === 'anularFactura') {
        $factura_id = $_POST['factura_id'];
        $motivo_anulacion = $_POST['motivo_anulacion'];
        $res = $anulacionFacturaService->anularFactura($factura_id, $motivo_anulacion);
        echo json_encode($res);
    } else if ($_POST['metodo'] === 'verificarFactura') {
        $venta_id = $_POST['id_venta'];

        $res = $anulacionFacturaService->verEstadoFactura($venta_id);
        echo json_encode($res);
    } else if ($_POST['metodo'] === 'obtenerEventoSignificativo') {
        $id_factura = $_POST['id_factura'];

        $res = $anulacionFacturaService->getEstadoAnulacionIdFactura($id_factura);

        $res = json_decode($res);
        echo json_encode([
            "transaccion" => true,
            "msg" => $res
        ]);
    }else if ($_POST['metodo'] === 'revertirFactura'){
        $id_factura = $_POST['factura_id'];
        $resReversion = $anulacionFacturaService->revertirAnulacionFactura($id_factura);
        echo json_encode($resReversion);

    }
}
