<?php
//require_once 'C:\xampp\htdocs\facturacion\API_REST\function\helpers\Letras.php';
//require_once 'C:\xampp\htdocs\facturacion\vendor\autoload.php';

require_once __DIR__ . '/helpers/Letras.php';
require_once __DIR__ . '/../../vendor/autoload.php';

use \Config as ConfiguracionDB;
use App\Custom\Letras as ConvertirLiteral;
//use SimpleSoftwareIO\QrCode\Generator; 
use SimpleSoftwareIO\QrCode\BaconQrCodeGenerator;
use Luecano\NumeroALetras\NumeroALetras;

function obtenerUnidadMedidaLiteral($id_unidad)
{
    $producto_id = $id_unidad;
    $db = ConfiguracionDB::getConnection();
    $sql = "SELECT * FROM `impuestos_unidadmedida` WHERE  codigoclasificador=:id LIMIT 1";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':id', $producto_id);
    $stmt->execute();
    $producto_unidad = $stmt->fetch(\PDO::FETCH_ASSOC);

    return json_encode($producto_unidad);
}

function obtenerLinkQR()
{
    $db = ConfiguracionDB::getConnection();
    $sql = "SELECT * FROM linksin LIMIT 1";
    $stmt = $db->prepare($sql);
    $stmt->execute();
    $producto_unidad = $stmt->fetch(\PDO::FETCH_ASSOC);

    return json_encode($producto_unidad);
}

function buildFacturaMiddlePage($dataFactura, $dataVenta)
{
    //$text = "https://pilotosiat.impuestos.gob.bo/consulta/QR?nit=" . $dataFactura->cabecera->nitEmisor . "&cuf=" . $dataFactura->cabecera->cuf . "&numero=" . $dataFactura->cabecera->numeroFactura . "&t=2";
    $text = (json_decode(obtenerLinkQR()))->linkcodigoqr . $dataFactura->cabecera->nitEmisor . "&cuf=" . $dataFactura->cabecera->cuf . "&numero=" . $dataFactura->cabecera->numeroFactura . "&t=2";
    $qrcode = new BaconQrCodeGenerator();
    $qr_generado = $qrcode->format('png')->margin(0)->size(100)->generate($text);
    $imgData = "data:image/png;base64," . base64_encode($qr_generado);
    /* unlink('qrcode.png'); */
    file_put_contents('qrcode.png', $qrcode->format('png')->margin(0)->size(100)->generate($text));
    /* $qrcode = QrCode::create($text)->setErrorCorrectionLevel(new ErrorCorrectionLevelHigh);
    $writer = new PngWriter;
    $result = $writer->write($qrcode);
    header("Content-Type: " . $result->getMimeType()); */
    if (isset($dataVenta['evento_significativo_id'])) {
        $estadoFacturaEmision = $dataVenta['evento_significativo_id'] != -1 ? "“Este documento es la Representación Gráfica de un Documento Fiscal Digital emitido fuera de línea, verifique su envío con su proveedor o en la página web<br>www.impuestos.gob.bo”" : "“Este documento es la Representación Gráfica de un Documento Fiscal Digital emitido en una modalidad de facturación en línea”";
    } else {
        $estadoFacturaEmision = "“Este documento es la Representación Gráfica de un Documento Fiscal Digital emitido en una modalidad de facturación en línea”";
    }
    //Numeros a letras
    $formatter = new NumeroALetras();
    $formatter->apocope = true;
    $formatter->conector = ' ';

    //
    $complemento_cli = isset($dataFactura->cabecera->complemento) ? $dataFactura->cabecera->complemento : '';
    $matriz_sucursal = $dataFactura->cabecera->codigoSucursal === 0 ? 'CASA MATRIZ' : 'SUCURSAL:' . $dataFactura->cabecera->codigoSucursal;
    if (strlen($dataFactura->cabecera->direccion) > 33) {
        $direccion_part1 =
            " " . substr($dataFactura->cabecera->direccion, 0, 33);
        $direccion_part2 =
            " " . substr($dataFactura->cabecera->direccion, 33, strlen($dataFactura->cabecera->direccion));
    } else {
        $direccion_part1 = $dataFactura->cabecera->direccion;
    }
    $cuf_part1 = " " . substr($dataFactura->cabecera->cuf, 0, 39);
    $cuf_part2 = " " . substr($dataFactura->cabecera->cuf, 40, 56);
    $html =  '<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title> FACTURA</title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }

        table {
            font-size: x-small;
        }

        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }

        .gray {
            background-color: lightgray
        }

        h3,
        h5 {
            text-align: center;
            margin: 2px;
        }

        .bordes {
            border: 1px solid black;
            border-spacing: 0;
            border-collapse: collapse;
        }

        .box {
            border: 5px solid darkblue;
            height: 30px;
            width: 10px;
        }

        .fernandin {
            white-space: initial;
        }

        table {
            table-layout: fixed;
        }

        td {
            word-wrap: break-word
        }
        @page {
            margin-top: 0cm;            
	    }
    </style>
</head>

<body style="padding: 0px 0px 0px 0px; margin: 0px 0px 0px 0px;">
    <table width="100%" cellspacing="0" cellpadding="0" style="padding: 0px 0px 0px 0px; margin: 0px 0px 0px 0px;">        
        <tr>            
            <td style="width: 30%;text-align:center; margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px; word-wrap: break-word;" rowspan="4">
                <p style="vertical-align:text-top;">
                <pre>
                <strong>' . $dataFactura->cabecera->razonSocialEmisor  . '
                ' . $matriz_sucursal . '</strong>
                Nro Punto de Venta: ' .   $dataFactura->cabecera->codigoPuntoVenta . '
                ' . $direccion_part1 . '
                ' . $direccion_part2 . '
                Telefono: ' . $dataFactura->cabecera->telefono . '
                ' . $dataFactura->cabecera->municipio . '
                </pre>
                </p>
            </td>
            
        </tr>        
        <tr style="text-align: left;">
            <td style="width: 50%;text-align:center; margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px;">
            </td>
            <td style="width:10%;vertical-align:text-top;">
                NIT:
            </td>
            <td style="width:20%;vertical-align:text-top; margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px;"> ' . $dataFactura->cabecera->nitEmisor . ' </td>
        </tr>
        <tr style="text-align: left;">
            <td style="width: 40%;text-align:center; margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px;">
            </td>
            <td style="width:10%; max-width:400px;min-width:300px;vertical-align:text-top;">
                FACTURA N*:
            </td>
            <td style="width:20%;vertical-align:text-top;">' . $dataFactura->cabecera->numeroFactura .  '</td>
        </tr>
        <tr style="text-align: left;">
            <td style="width: 40%;text-align:center; margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px;">
            </td>
            <td style="width:15%;vertical-align:text-top;">
                COD. AUTORIZACIÓN:
            </td>
            <td style="width:10%; max-width:400px;min-width:300px;vertical-align:text-top;">
                ' . $cuf_part1  . $cuf_part2 . '
            </td>
        </tr>
    </table>

    <h3>FACTURA</h3>
    <h5>(Con derecho a credito fiscal)</h5>

    <table width="100%;" style="text-align:left;">
        <tr>
            <td><strong>Fecha:</strong> </td>
            <td> ' . date_format(date_create($dataFactura->cabecera->fechaEmision), 'd/m/Y')  . ' </td>        
            <td style="width:45%;"></td>            
            <td style="text-align: right;"><strong>NIT/CI/CEX:</strong></td>
            <td>' . $dataFactura->cabecera->numeroDocumento . '
        </tr>
        <tr>
            <td><strong>Nombre/Razon Social:</strong></td>
            <td> ' . $dataFactura->cabecera->nombreRazonSocial  . ' </td>
            <td style="width:45%;"></td>            
            <td style="text-align: right;"><strong>Cod. Cliente:</strong></td>
            <td> ' . $dataFactura->cabecera->codigoCliente . ' </td>
        </tr>
        <tr>
            <td></td>            
            <td></td>
            <td style="width:45%;"></td>            
            <td style="text-align: right;"><strong>Complemento:</strong></td>
            <td>' . $complemento_cli . '</td>
        </tr>
    </table>

    <br />

    <table width="100%">
        <thead style="background-color: lightgray;">
            <tr class="">
                <th class="">
                    <p>CODIGO <BR>PRODUCTO /<BR> SERVICIO</p>
                </th>
                <th class="">CANTIDAD</th>
                <th class="">UNIDAD DE MEDIDA</th>
                <th class="">DESCRIPCION</th>
                <th class="">
                    <P>PRECIO<BR> UNITARIO</P>
                </th>
                <th class="">DESCUENTO</th>
                <th class="">SUBTOTAL</th>
            </tr>
        </thead>
        <tbody>';
    foreach ($dataFactura->detalle  as $detalle) {
        $html .= '
            <tr class="active-row">
            <td style="text-align: center;">' . $detalle->codigoProducto . '</td>
            <td style="text-align: center;">' . number_format($detalle->cantidad, 2) . '</td>
            <td style="text-align: center;">' . (json_decode(obtenerUnidadMedidaLiteral($detalle->unidadMedida)))->descripcion . ' </td>
            <td style="text-align: center;">' . $detalle->descripcion . '</td>
            <td style="text-align: right;">' . number_format($detalle->precioUnitario, 2) . '</td>
            <td style="text-align: right;">' . number_format($detalle->montoDescuento, 2) . '</td>
            <td style="text-align: right;">' . number_format($detalle->subTotal, 2) . '</td>
            </tr>';
    }
    $convertirLiteral = new ConvertirLiteral();
    $html .= '
            <tr>
                <td colspan="4"></td>
                <td colspan="2" style="text-align: right;">SUBTOTAL Bs.</td>
                <td style="text-align: right;"> ' . number_format(array_reduce($dataFactura->detalle, function ($carry, $item) {
        return $carry + $item->subTotal;
    }), 2) . ' </td>
            </tr>
            <tr>
                <td colspan="4"></td>
                <td colspan="2" style="text-align: right;">DESCUENTO Bs.</td>
                <td style="text-align: right;"> ' . number_format($dataFactura->cabecera->descuentoAdicional, 2) . ' </td>
            </tr>
            <tr>
                <td colspan="4"></td>
                <td colspan="2" style="text-align: right;">TOTAL Bs.</td>
                <td style="text-align: right;"> ' . number_format($dataFactura->cabecera->montoTotal, 2) . '  </td>
            </tr>
            <tr>
                <td colspan="4" style="text-align: left;"> <b> Son: ' .
        $formatter->toInvoice($dataFactura->cabecera->montoTotalSujetoIva, 2, 'Bolivianos') . '<b></td>
                <td colspan="2" style="text-align: right;">MONTO GIFT CARD Bs.</td>
                <td style="text-align: right;"> ' . number_format($dataFactura->cabecera->montoGiftCard, 2) . '</td>
            </tr>
            <tr>
                <td colspan="4"></td>
                <td colspan="2" style="text-align: right;"><b>MONTO A PAGAR Bs. </b> </td>
                <td style="text-align: right;"><b>' . number_format($dataFactura->cabecera->montoTotalSujetoIva, 2) . '</b> </td>
            </tr>
            <tr>
                <td colspan="4"></td>
                <td colspan="2" style="text-align: right;"><b>IMPORTE BASE CREDITO FISCAL Bs. </b> </td>
                <td style="text-align: right;"> <b> ' . number_format($dataFactura->cabecera->montoTotalSujetoIva, 2)  . '</b> </td>
            </tr>
        </tbody>
    </table>
   <table width="100%" cellspacing="0" cellpadding="0" style="text-align:center; margin-top: 50px; border-collapse: collapse;" border="0">
    <tr>
        <td width="10%"></td>
        <td width="40%" style="padding: 0px 0px 0px 0px; margin: 0px 0px 0px 0px; border-spacing: 0px;">
            <small style="text-align:center; font-size: 9px;">
                <pre>ESTA FACTURA CONTRIBUYE AL DESARROLLO DEL PAÍS, EL USO ILÍCITO SERÁ SANCIONADO PENALMENTE DE ACUERDO A LEY</pre>
            </small>
        </td>
        <td width="20%" rowspan="3" cellspacing="0" cellpadding="0">
            <img src="' . $imgData . '" border="0">
        </td>
    </tr>
    <tr>
        <td width="10%"></td>
        <td width="40%" style="padding: 0px 0px 0px 0px; margin: 0px 0px 0px 0px; border-spacing: 0px;">
            <small style="text-align:center; font-size: 9px;">
                <pre>' . $dataFactura->cabecera->leyenda . '</pre>
            </small>
        </td>
    </tr>
    <tr>
        <td width="10%"></td>
        <td width="40%" style="padding: 0px 0px 0px 0px; margin: 0px 0px 0px 0px; border-spacing: 0px;">
            <small style="text-align:center; font-size: 9px;">
                <div style="max-width: 100%;">
                    <pre> ' . $estadoFacturaEmision . '</pre>
                </div>
            </small>
        </td>
    </tr>
    <tr></tr>
    <tr></tr>
    <tr></tr>            
</table>
  
</body>

</html>';

    return $html;
}
