<?php

use App\ServiciosSiat\EventoSignificativoService;

//require_once 'C:\xampp\htdocs\facturacion\API_REST\function\helpers\Letras.php';
require_once __DIR__ . '/helpers/Letras.php';


function buildFacturaVaucher($dataFactura, $dataVenta)
{
    $cuf_part1 = " " . substr($dataFactura->cabecera->cuf, 0, 39);
    $cuf_part2 = " " . substr($dataFactura->cabecera->cuf, 40, 56);
    $html = '<!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Factura</title>
        <style>
            * {
                margin: 0;
                color: #1f1f1f;
                font-size: 13px;
                width: 300px;
                max-width: 300px;
            }
            .container {
                background: #fff;
                padding: 20px 10px;
            }
            .cabecera {
                text-align: center;
                margin-bottom: 10px;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="receipt">
                <div class="cabecera">
                    FACTURA<br>
                    CON DERECHO A CREDITO FISCAL<br>
                    DONESCO SRL<br>
                    ' . $dataVenta['id_sucursal'] . '<br>
                    Nro Punto de Venta 0<br>
                    ' . $dataVenta['id_sucursal'] . '<br>
                    Tel. 78555410<br>
                    Santa Cruz de la Sierra<br>
                </div>
                <div class="break">
                    ----------------------------------------------------------------------------------
                </div>
                <div class="cabecera">
                    NIT<br>
                    166172023<br>
                    FACTURA N*<br>
                    ' . $dataFactura->cabecera->numeroFactura . '<br>
                    CODIGO AUTORIZACION<br>
                    <p style="padding-left: 45px;">' . $cuf_part1 . ' </p>
                    <p style="padding-left: 25px;"> ' . $cuf_part2 . ' </p>
                </div>
                <div class="break">
                    ----------------------------------------------------------------------------------
                </div>
                <div class="contenido">
                    <div class="cliente">
                        <div class="campo">
                            <div class="etiqueta">NOMBRE/RAZON SOCIAL:</div>
                            <div class="valor">' . $dataFactura->cabecera->nombreRazonSocial . '</div>
                        </div>
                        <div class="campo">
                            <div class="etiqueta">NIT/CI/CEX:</div>
                            <div class="valor">' . $dataFactura->cabecera->numeroDocumento . '</div>
                        </div>
                    </div>
                    <div style="clear: left;"></div>
                    <div class="">
                        <div style=" float: left; width: 75%; ">COD. CLIENTE:</div>
                        <div style=" margin-left: 35%;">' . $dataFactura->cabecera->codigoCliente . '</div>
                    </div>
                    <div style="clear: left;"></div>
                    <div class="">
                        <div style="float: left; width: 75%;  ">FECHA EMISION:</div>
                        <div style="margin-left: 35%; ">' . date_format(date_create($dataFactura->cabecera->fechaEmision), 'd/m/Y')  . '</div>
                    </div>
                    <div style="clear: left;"></div>
                    <div class="break">
                        ----------------------------------------------------------------------------------
                    </div>
                    <p style="text-align: center;">DETALLE</p>
                    <div>';
    foreach ($dataFactura->detalle as $detalle) {
        $html .=
            '<div>
            ' . $detalle->codigoProducto . '-' . $detalle->descripcion . '
            </div>
            <div>';
        $resUnidadMedida = (new EventoSignificativoService())->obtenerUnidadMedidaLiteral($detalle->unidadMedida);
        $unidadMedidaDescripcion = json_decode($resUnidadMedida)->descripcion;
        echo $unidadMedidaDescripcion;
        echo '</div>
            
                            <div style="float: left; width: 85%;  ">
                            ' . number_format($detalle->cantidad, 2) . 'x' . number_format($detalle->precioUnitario, 2)  . '-' . number_format($detalle->montoDescuento, 2)  . '
                            </div>
                            <div style="margin-left: 85%;  ">
                            ' . number_format($detalle->subTotal, 2) . '
                            </div>
                            <div style="clear: left;"></div>';
    }
    $html .= ' <div class="break">
                        ----------------------------------------------------------------------------------
                    </div>
                    <div style="text-align: center;">
                    <div class="">
                        <div style="float: left;margin-left: 5%; width: 85%; ">SUBTOTAL Bs.</div>
                        <div style="margin-left: 5%; ">' . number_format($dataFactura->cabecera->montoTotal, 2) . '</div>
                    </div>
                    <div style="clear: left;"></div>
                    <div>
                        <div style="float: left;margin-left: 5%; width: 85%; ">DESCUENTO Bs. </div>
                        <div style="margin-left: 5%; ">0.00</div>
                    </div>
                    <div style="clear: left;"></div>
                    <div>
                        <div style="float: left;margin-left: 5%; width: 85%; ">TOTAL Bs. </div>
                        <div style="margin-left: 5%; ">' . number_format($dataFactura->cabecera->montoTotal, 2) . '</div>
                    </div>
                    <div style="clear: left;"></div>
                    <div>
                        <div style="float: left;margin-left: 5%; width: 85%; ">MONTO GIFT CARD Bs.</div>
                        <div style="margin-left: 5%; ">0.00</div>
                    </div>
                    <div style="clear: left;"></div>
                    <div>
                        <div style="float: left;margin-left: 5%; width: 85%; ">MONTO A PAGAR Bs. </div>
                        <div style="margin-left: 5%; ">' . number_format($dataFactura->cabecera->montoTotal, 2) . '</div>
                    </div>
                    <div style="clear: left;"></div>
                    <div>
                        <div style="float: left;margin-left: 5%; width: 85%; ">IMPORTE CREDITO FISCAL Bs.</div>
                        <div style="margin-left: 5%; ">' . number_format($dataFactura->cabecera->montoTotalSujetoIva, 2) . '</div>
                    </div>
                    <div style="clear: left;"></div>
                    <p> Son: ' . number_format($dataFactura->cabecera->montoTotalSujetoIva, 2) . ' 00/100 Bolivianos </p>
                </div>
                <div class="break">
                    ----------------------------------------------------------------------------------
                </div>
        </div>
    </body>
    </html>';
    return $html;
}
