<?php
function imageResize($source, int $width, int $height = null, int $red = 0 , int $green = 0 , int $blue = 0)
{
    if (is_null($height)) {
        $height = $width;
    }

    $input = imagecreatefromstring($source);

    $widthOrig = imagesx($input);
    $heightOrig = imagesy($input);

    $pw = $width / $widthOrig;
    $ph = $height / $heightOrig;
    $pm = $pw < $ph ? $pw : $ph;

    $widthDest = $widthOrig * $pm;
    $heightDest = $heightOrig * $pm;
    
    $output = imagecreatetruecolor($widthDest, $heightDest);
    //$output = imagecreatetruecolor($width, $height);
    //imagefill($output, 0, 0,  imagecolorallocate($output, $red , $green , $blue ));
    
    imagecopyresampled($output, $input, 0, 0, 0, 0, $widthDest, $heightDest, $widthOrig, $heightOrig);
    //imagecopyresampled($output, $input, ($width - $widthDest) / 2, ($height - $heightDest) / 2, 0, 0, $widthDest, $heightDest, $widthOrig, $heightOrig);
    return $output;
}

function imageProducto($imgbase64,$idEmpresa,$tipo){
    $dir = subir_productos . $idEmpresa . '/';
    if (file_exists($dir) == false) {
        mkdir($dir, 0777);
    }
    $image_parts = explode(";base64,", $imgbase64);
    $image_base64 = base64_decode($image_parts[1]);
    $file1 = $tipo.time(). '.png';
    imagepng(imageResize($image_base64, 600), $dir . $file1);
    return  $file1;
}
?>