<?php

namespace App\API_REST\Offline;

require_once __DIR__ . '/../../API_REST/function/conexion_singleton.php';
require_once __DIR__ . '/../../ServiciosSiat/EventoSignificativoService.php';

use Config;
use App\ServiciosSiat\EventoSignificativoService;
use App\ServiciosSiat\ConfigService;
use DateTime;

date_default_timezone_set('America/La_Paz');

class EmitirOffLine
{
    public $configService;

    public function __construct()
    {
        $this->configService = new ConfigService();
    }

    public function buildCuf($codigoControl, $numeroFactura, $fechaEmision)
    {
        $modalidad              = $this->configService->config->modalidad;
        $tipoFactura            = $this->configService->tipoFactura;
        $tipoEmision            = 2;

        $nitEmisor              = str_pad($this->configService->config->nit, 13, '0', STR_PAD_LEFT);
        $sucursalNro            = str_pad($this->configService->sucursal, 4, '0', STR_PAD_LEFT);
        $tipoSector             = str_pad($this->configService->documentoSector, 2, '0', STR_PAD_LEFT);
        $numeroFactura          = str_pad($numeroFactura, 10, '0', STR_PAD_LEFT);
        $numeroPuntoVenta       = str_pad($this->configService->puntoventa, 4, '0', STR_PAD_LEFT);
        $fechaHora              = date('YmdHisv', strtotime($fechaEmision));
        //date( 'YmdHisv' );
        /*  print_r( $fechaHora );
        */
        /*
        $nitEmisor 			 = str_pad( '123456789', 13, '0', STR_PAD_LEFT );
        $sucursalNro 		 = str_pad( '0', 4, '0', STR_PAD_LEFT );
        $tipoSector 		 = str_pad( '1', 2, '0', STR_PAD_LEFT );
        $numeroFactura 		 = str_pad( '1', 10, '0', STR_PAD_LEFT );
        $numeroPuntoVenta 	 = str_pad( '0', 4, '0', STR_PAD_LEFT );
        $fechaHora 			 = '20190113163721231';
        */

        $cadena         = "{$nitEmisor}{$fechaHora}{$sucursalNro}{$modalidad}{$tipoEmision}{$tipoFactura}{$tipoSector}{$numeroFactura}{$numeroPuntoVenta}";

        $verificador     = $this->calculaDigitoMod11($cadena, 1, 9, false);
        //$b16_str 		 = $this->bcdechex( ltrim( $cadena . $verificador ) );
        $b16_str         = strtoupper($this->bcdechex($cadena . $verificador));

        return $b16_str . $codigoControl;
        //die( 'cadena length: '. strlen( $cadena ) ."\nverificador: $verificador\nb16_str: $b16_str\nCUF: {$this->header->cuf}\n" );
        /*
        print "Cadena: $cadena\nLength: " . strlen( $cadena ) . '\n';
        echo 'Cadena INT: ', ltrim( $cadena . $verificador, '0' ), '\n';
        echo 'Cadena HEX: ', dechex( $cadena . $verificador ), '\n';
        echo 'Verificador: ', $verificador, '\n';
        echo 'B16: ', $b16_str, '\n';
        echo 'CUF: ', $this->cabecera->cuf, '\n';
        //*/
    }

    public function bcdechex($dec)
    {
        $hex = '';
        do {
            $last = bcmod($dec, 16);
            $hex = dechex($last) . $hex;
            $dec = bcdiv(bcsub($dec, $last), 16);
        } while ($dec > 0);
        return $hex;
    }

    public function calculaDigitoMod11(string $cadena, int $numDig, int $limMult, bool $x10)
    {
        $cadenaSrc = $cadena;

        $mult = $suma = $i = $n = $dig = 0;

        if (!$x10) $numDig = 1;

        for ($n = 1; $n <= $numDig; $n++) {
            $suma = 0;
            $mult = 2;
            for (
                $i = strlen($cadena) - 1;
                $i >= 0;
                $i--
            ) {
                $cadestr = $cadena[$i];
                //substr( $cadena, $i, $i + 1 );
                $intNum = (int)($cadestr);
                //echo 'cadestr: ', $cadestr, '\n';
                //echo 'intNum: ', $intNum, '\n';
                $suma += ($mult * $intNum);
                if (++$mult > $limMult) $mult = 2;
            }
            if ($x10) {
                $dig = (($suma * 10) % 11) % 10;
            } else {
                $dig = $suma % 11;
            }
            if ($dig == 10) {
                $cadena .= '1';
            }
            if ($dig == 11) {
                $cadena .= '0';
            }
            if ($dig < 10) {

                //$cadena .= String.valueOf( dig );
                $cadena .= $dig;
            }
            //echo 'Dig: ', $dig, '\n';
        }

        $modulo = substr($cadena, strlen($cadena) - $numDig, strlen($cadena));

        //echo $cadena, '\n';
        //echo 'Calculado modulo 11: ', $cadenaSrc, ' => ', $modulo, '\n';

        return $modulo;
    }

    public function cargar_contador_usuario($id_usuario, $db)
    {
        try {
            $sql = "SELECT u.contador+1 as contador
        from per_usuarios u
        where u.id= :id_usuario ";
            $stmt = $db->prepare($sql);
            $stmt->bindParam('id_usuario', $id_usuario);
            $stmt->execute();
            $i = 0;
            if ($stmt->rowCount() > 0) {
                while ($data  = $stmt->fetch(\PDO::FETCH_ASSOC)) {
                    $array['contador']                = trim($data['contador']);
                    $i++;
                }
                return $array;
            } else {
                return false;
            }
        } catch (\PDOException $e) {
            $db = null;
            $stmt = null;
            return $e;
        }
    }

    function obtenerCuis()
    {
        if (!isset($_SESSION)) {
            session_start();
        }
        $userData = json_decode($_SESSION['dataUser']);
        $userID = $userData->id;
        $empresaUser = $userData->id_empresa;
        $estado = 1;
        $db = Config::getConnection();
        $query = "SELECT * from puntodeventa p 
          join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
          where pvu.user_id = :user_id
          and p.id_empresa = :id_empresa
          and p.estado = :estado LIMIT 1; ";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':user_id', $userID);
        $stmt->bindParam(':id_empresa', $empresaUser);
        $stmt->bindParam(':estado', $estado);
        $stmt->execute();
        $cuis = $stmt->fetch();
        return $cuis;
    }

    public function obtenerCufd()
    {
        if (!isset($_SESSION)) {
            session_start();
        }
        $userData = json_decode($_SESSION['dataUser']);
        $empresaUser = $userData->id_empresa;
        $dataPuntoVenta = $this->obtenerCuis();
        $db = Config::getConnection();
        $sql = "SELECT * 
        from impuestos_cufd ic 
        where ic.id_empresa =:empresa_id and ic.cuis =:cuis";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':empresa_id', $empresaUser);
        $stmt->bindParam(':cuis', $dataPuntoVenta['ccuis']);
        $stmt->execute();
        $cufd = $stmt->fetch();


        return $cufd;
    }

    public function cargar_Inv_Producto_Cantidad($db, $id_producto, $id_almacen, $configuracion, $cantidad_mayor)
    {
        // 1 = mayor a 0, 2 = menor a 0
        try {
            $asc = ' asc ';
            $ordenar = ' and i.cantidad>0';
            $limite = ' limit 1 ';
            if ($configuracion == 2) {
                $asc = ' desc ';
            }
            if ($cantidad_mayor == 2) {
                $ordenar = ' and i.cantidad<=0 ';
            }
            $sql = "SELECT i.id,i.id_det_ingreso,i.id_producto,i.id_almacen,i.cantidad
        ,di.costo,round(di.costo/di.cantidad,3) as costo_un
        from in_inventario i,in_det_ingreso di
        where i.id_det_ingreso=di.id
        and i.id_producto=:id_producto
        and i.id_almacen=:id_almacen
        $ordenar
        order by i.fecha_reg $asc
        $limite ";
            $stmt = $db->prepare($sql);
            $stmt->bindParam('id_producto', $id_producto);
            $stmt->bindParam('id_almacen',  $id_almacen);
            $stmt->execute();
            $i = 0;
            if ($stmt->rowCount() > 0) {
                while ($data  = $stmt->fetch(\PDO::FETCH_ASSOC)) {
                    $array[$i]['id']                = trim($data['id']);
                    $array[$i]['id_det_ingreso']    = trim($data['id_det_ingreso']);
                    $array[$i]['id_producto']       = trim($data['id_producto']);
                    $array[$i]['id_almacen']        = trim($data['id_almacen']);
                    $array[$i]['cantidad']          = trim($data['cantidad']);
                    $array[$i]['costo']             = trim($data['costo']);
                    $array[$i]['costo_un']          = trim($data['costo_un']);

                    $i++;
                }
                return $array;
            } else {
                return false;
            }
        } catch (\PDOException $e) {
            $db = null;
            $stmt = null;
            return $e;
        }
    }

    public function insertar_venta_detalle($db, $data, $cantidad, $data_ingreso, $id_venta)
    {

        try {
            // echo json_encode( $data );
            $fechaReg = date('Y-m-d H:i:s');
            $sql = "INSERT INTO det_venta
                    (id_venta,id_almacen, id_producto, cantidad,precio, costo, id_det_ingreso, descuento_item)
                    VALUES
                    (:id_venta,:id_almacen, :id_producto, :cantidad,:precio,:costo,:id_det_ingreso, :descuento_item)";
            $data['desc'] = empty($data['desc']) ? null : $data['desc'];
            $stmt = $db->prepare($sql);
            $stmt->bindParam('id_venta',      $id_venta);
            $stmt->bindParam('id_almacen',    $data['id_almacen']);
            $stmt->bindParam('id_producto',   $data['id_producto']);
            $stmt->bindParam('cantidad',      $cantidad);
            $stmt->bindParam('precio',        $data['precio']);
            $stmt->bindParam('costo',         $data['costo']);
            $stmt->bindParam('id_det_ingreso', $data_ingreso['id_det_ingreso']);
            $stmt->bindParam('descuento_item', $data['desc']);
            $stmt->execute();
            $id = $db->lastInsertId();
            $i = 0;
            if ($stmt->rowCount() > 0) {
                return $id;
            } else {
                return false;
            }
        } catch (\PDOException $e) {
            $db = null;
            $stmt = null;
            return $e;
        }
    }

    function actualizar_inventario($db, $data, $id_detalle)
    {
        try {

            $fechaReg = date('Y-m-d H:i:s');
            $sql = "UPDATE  in_inventario set cantidad=cantidad - :cantidad, fecha_up=:fecha_up where id=:id";
            $stmt = $db->prepare($sql);
            $stmt->bindParam('id', $id_detalle);
            $stmt->bindParam('cantidad',       $data['cantidad']);
            $stmt->bindParam('fecha_up',       $fechaReg);

            $stmt->execute();
            $id = $db->lastInsertId();
            $i = 0;
            if ($stmt->rowCount() > 0) {
                return true;
            } else {
                return false;
            }
        } catch (\PDOException $e) {
            $db = null;
            $stmt = null;
            return $e;
        }
    }

    public function getLastVenta()
    {
        $db = Config::getConnection();
        $sql = "SELECT IFNULL(MAX(nro_factura),0) AS nro_factura
         FROM venta";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $lastVenta = $stmt->fetch();
        return $lastVenta['nro_factura'];
    }

    public function getLastVentaEvento($idEvento)
    {
        $db = Config::getConnection();
        $sql = "SELECT IFNULL(MAX(nro_factura),0) AS nro_factura
         FROM venta WHERE evento_significativo_id=:evento_significativo_id";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':evento_significativo_id', $idEvento);
        $stmt->execute();
        $lastVenta = $stmt->fetch();
        return $lastVenta['nro_factura'];
    }



    public function getLastVentaInserted($nroFactura)
    {
        $db = Config::getConnection();
        $sql = "SELECT *
         FROM venta 
         where nro_factura=:nro_factura";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':nro_factura', $nroFactura);
        $stmt->execute();
        $lastVenta = $stmt->fetch();
        return $lastVenta;
    }

    public function actualizar_contador($db, $id_usuario, $contador)
    {
        try {

            $fechaReg = date('Y-m-d H:i:s');
            $sql = "UPDATE  per_usuarios
        set
        contador=:contador
        where id=:id_usuario
        ";
            $stmt = $db->prepare($sql);
            $stmt->bindParam('id_usuario', $id_usuario);
            $stmt->bindParam('contador', $contador);
            $stmt->execute();
            $i = 0;
            if ($stmt->rowCount() > 0) {
                return true;
            } else {
                return false;
            }
        } catch (\PDOException $e) {
            $db = null;
            $stmt = null;
            return $e;
        }
    }

    public function obtenerLeyendas()
    {
        $db = Config::getConnection();
        $sql = "SELECT *
                FROM impuestos_leyendasfacturas";
        $stmt = $db->prepare($sql);
        $stmt->execute();

        return $stmt;
    }

    public function obtenerLeyenda($id)
    {
        $param['id'] = $id;
        $db = Config::getConnection();
        $sql = 'SELECT * FROM impuestos_leyendasfacturas WHERE idleyendasfacturas =:id';
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $param['id']);
        $stmt->execute();

        return $stmt->fetch();
    }

    function getParametroSiat()
    {
        if (!isset($_SESSION)) {
            session_start();
        }

        $userEmpresaID = json_decode($_SESSION['dataUser']);
        $db = Config::getConnection();
        $query = "SELECT * FROM parametro_sin ps
            WHERE ps.id_empresa =:id_empresa 
            ORDER BY ps.id_empresa DESC
            LIMIT 1";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id_empresa', $userEmpresaID->id_empresa);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $parametroSin = $stmt->fetch(\PDO::FETCH_ASSOC);
            return $parametroSin;
        }
        return null;
    }

    public function insertar_venta($dataVenta_decode)
    {
        $resVenta = $this->insertar_venta_offline($dataVenta_decode);
        echo json_encode($resVenta);
    }


    public function insertar_venta_offline($dataVenta_decode)
    {
        date_default_timezone_set("America/La_Paz");
        $estadoAnulacion = 0;
        $estadoEmision = 'P';
        $codigoPuntoVenta = $this->configService->puntoventa;
        $cufdId = $this->obtenerCufd();
        $dataVenta = json_decode($dataVenta_decode, true);
        $eventoRegistrado = new EventoSignificativoService();
        $res = $eventoRegistrado->getEventExists(false);
        $parametroSin = $this->getParametroSiat();
        $evento_significativo_id = -1;

        if (isset($res['CodigoDesc'])) {
            $evento_significativo_id = $res['CodigoDesc'];
        }
        //? Validamos que si Existe un evento 5,6,7 , las facturas registradas tomen la numeracion del CAFC
        /* $numeroFactura = $dataVenta['nro_factura']; */
        if ($evento_significativo_id == 5 || $evento_significativo_id == 6 || $evento_significativo_id == 7) {
            $numeroFacturaFin = $parametroSin['hasta'];
            $numeroFacturaNum = $this->getLastVentaEvento($evento_significativo_id) + 1;
            if ($numeroFacturaNum <= $numeroFacturaFin) {
                $numeroFactura = $numeroFacturaNum;
            } else {
                $mensaje = 'Limite de Numeracion Alcanzado';
                return [
                    "transaccion" => false,
                    "msg" => $mensaje
                ];
            }
        } else {
            $numeroFactura = $this->getLastVenta() + 1;
        }


        // ! Validamos que la fecha de Registro de las facturas esten Dentro de la fechaInicio y Fin del Evento
        $fechaVenta = (new DateTime($dataVenta['fecha_venta']))->format('Y-m-d H:i:s.u');
        $fechaInicioEvento = $res['FechaInicio'];
        $fechaFinEvento = $res['FechaFinal'];
        if ($fechaVenta < $fechaInicioEvento || $fechaVenta > $fechaFinEvento) {
            $mensaje = 'Fecha Venta no Corresponde al Rango de Fechas del Evento';
            return [
                "transaccion" => false,
                "msg" => "La fecha venta tiene que estar dentro del rango-fecha incio= " . $fechaInicioEvento . " y fecha final= " . $fechaFinEvento
            ];
        }


        $db = Config::getConnection();
        $db->beginTransaction();
        try {
            $contador = $this->cargar_contador_usuario($dataVenta['id_usuario'], $db);

            $sql = "INSERT INTO venta
                    (id_sucursal,id_cliente,fecha_venta
                    ,tipo_venta,total,estado,saldo,nota
                    ,fecha_reg,fecha_up,id_usuario,descuento,tipo_pago,tarjeta,es_paquete
                    ,cambio,merma,moneda_id,monto_giftcard
                    ,cuf,leyenda,nro_factura,estado_emision,cufd_id,punto_venta_id,estado_anulacion
                    ,evento_significativo_id, data_extra)
            
                    VALUES
                    ( :id_sucursal,:id_cliente,:fecha_venta
                    ,:tipo_venta,:total,:estado,:saldo,:nota
                    ,:fecha_reg,:fecha_up,:id_usuario,:descuento,:tipo_pago,:tarjeta,:es_paquete
                    ,:cambio,:merma,:moneda_id,:monto_giftcard
                    ,:cuf,:leyenda,:nro_factura,:estado_emision,:cufd_id ,:punto_venta_id,:estado_anulacion
                    ,:evento_significativo_id, :data_extra)";


            $construccionCuf = $this->buildCuf($res['CodigoControl'], $numeroFactura, $dataVenta['fecha_venta']);

            $dataVenta['cuf'] = $construccionCuf;

            $leyendas = ($this->obtenerLeyendas()->rowCount());
            $leyendaItem = ($this->obtenerLeyenda(rand(1, $leyendas)));

            $dataVenta['leyenda'] = $leyendaItem['descripcion'];

            $dataVenta['nro_factura'] = $numeroFactura;
            $dataVenta['estado_emision'] = '2';
            $data_factura_code = json_encode([
                'sucursal_id' => $dataVenta['id_sucursal'],
                'codigoPuntoVenta' => $codigoPuntoVenta,
                'id_cliente' => $dataVenta['id_cliente']
            ]);

            $stmt = $db->prepare($sql);
            $stmt->bindParam('id_sucursal',             $dataVenta['id_sucursal']);
            $stmt->bindParam('fecha_venta',             $dataVenta['fecha_venta']);
            $stmt->bindParam('total',                   $dataVenta['total']);
            $stmt->bindParam('fecha_reg',               $dataVenta['fecha_venta']);
            $stmt->bindParam('fecha_up',                $dataVenta['fecha_venta']);
            $stmt->bindParam('cuf',                     $dataVenta['cuf']);
            $stmt->bindParam('leyenda',                 $dataVenta['leyenda']);
            $stmt->bindParam('nro_factura',             $numeroFactura);
            $stmt->bindParam('estado_emision',          $estadoEmision);
            $stmt->bindParam('id_cliente',              $dataVenta['id_cliente']);
            $stmt->bindParam('tipo_venta',              $dataVenta['tipo_venta']);
            $stmt->bindParam('estado',                  $dataVenta['estado']);
            $stmt->bindParam('saldo',                   $dataVenta['saldo']);
            $stmt->bindParam('nota',                    $dataVenta['nota']);
            $stmt->bindParam('id_usuario',              $dataVenta['id_usuario']);
            $stmt->bindParam('descuento',               $dataVenta['descuento']);
            $stmt->bindParam('tipo_pago',               $dataVenta['tipo_pago']);
            $stmt->bindParam('tarjeta',                 $dataVenta['tarjeta']);
            $stmt->bindParam('es_paquete',              $dataVenta['es_paquete']);
            $stmt->bindParam('cambio',                  $dataVenta['cambio']);
            $stmt->bindParam('merma',                   $contador['contador']);

            $stmt->bindParam('moneda_id',               $dataVenta['tipo_moneda']);
            $stmt->bindParam('monto_giftcard',          $dataVenta['monto_giftcard']);

            $stmt->bindParam('cufd_id',                 $cufdId['idcufd']);
            $stmt->bindParam('punto_venta_id',          $codigoPuntoVenta);
            $stmt->bindParam('estado_anulacion',          $estadoAnulacion);
            $stmt->bindParam('evento_significativo_id', $evento_significativo_id);
            $stmt->bindParam('data_extra',         $data_factura_code);

            $stmt->execute();
            $id = $db->lastInsertId();
            $error = 0;
            if ($stmt->rowCount() > 0) {
                foreach ((array)$dataVenta['productos'] as $key => $value) {
                    $cantidad = $value['cantidad'];
                    while ($cantidad > 0) {
                        $producto_inventario = $this->cargar_Inv_Producto_Cantidad($db, $value['id_producto'], $value['id_almacen'], 1, 1);
                        if ($producto_inventario) {
                            for (
                                $i = 0;
                                $i < count($producto_inventario);
                                $i++
                            ) {
                                if ($cantidad >= $producto_inventario[$i]['cantidad']) {
                                    $cantidad = $cantidad - $producto_inventario[$i]['cantidad'];
                                    $det_ = $this->insertar_venta_detalle($db, $value, $producto_inventario[$i]['cantidad'], $producto_inventario[$i], $id);

                                    $inv_ =  $this->actualizar_inventario($db, $value, $producto_inventario[$i]['id']);
                                } else {

                                    $det_ =  $this->insertar_venta_detalle($db, $value, $cantidad, $producto_inventario[$i], $id);
                                    $inv_ =   $this->actualizar_inventario($db, $value, $producto_inventario[$i]['id']);
                                    $cantidad = 0;
                                    $i = count($producto_inventario);
                                }
                            }
                            if (!$det_) {
                                $error++;
                            }
                            if (!$inv_) {
                                $error++;
                            }
                        } else {
                            $producto_inventario = $this->cargar_Inv_Producto_Cantidad($db, $value['id_producto'], $value['id_almacen'], 1, 2);
                            $det_ =   $this->insertar_venta_detalle($db, $value, $cantidad, $producto_inventario[0], $id);
                            $inv_ =  $this->actualizar_inventario($db, $value, $producto_inventario[0]['id']);
                            $cantidad = 0;
                            if (!$det_) {
                                $error++;
                            }
                            if (!$inv_) {
                                $error++;
                            }
                        }
                    }
                }
                $cont =   $this->actualizar_contador($db, $dataVenta['id_usuario'], $contador['contador']);
            }
            $db->commit();
            $stmt = null;

            return [
                "transaccion" => true,
                "msg" => [
                    "Se inserto correctamente"
                ]
            ];
        } catch (\PDOException $e) {
            $db->rollback();
            $db = null;
            throw $e;
        }
    }
}

$resVentaOffLine = new EmitirOffLine();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($_POST['metodo'] === 'insertar_venta') {
        $dataVenta = $_POST['enviar'];

        $res = $resVentaOffLine->insertar_venta($dataVenta);
    }
}
